/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.extension;

import io.smallrye.reactive.messaging.EmitterConfiguration;
import io.smallrye.reactive.messaging.providers.extension.AbstractEmitter;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;

public class EmitterImpl<T>
extends AbstractEmitter<T>
implements Emitter<T> {
    public EmitterImpl(EmitterConfiguration config, long defaultBufferSize) {
        super(config, defaultBufferSize);
    }

    public CompletionStage<Void> send(T payload) {
        if (payload == null) {
            throw ProviderExceptions.ex.illegalArgumentForNullValue();
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.emit(ContextAwareMessage.of(payload).withAck(() -> {
            future.complete(null);
            return CompletableFuture.completedFuture(null);
        }).withNack(reason -> {
            future.completeExceptionally((Throwable)reason);
            return CompletableFuture.completedFuture(null);
        }));
        return future;
    }

    public <M extends Message<? extends T>> void send(M msg) {
        if (msg == null) {
            throw ProviderExceptions.ex.illegalArgumentForNullValue();
        }
        this.emit(msg);
    }
}

