/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar.converters;

import io.smallrye.reactive.messaging.keyed.KeyValueExtractor;
import io.smallrye.reactive.messaging.providers.helpers.TypeUtils;
import io.smallrye.reactive.messaging.pulsar.PulsarIncomingMessageMetadata;
import jakarta.enterprise.context.ApplicationScoped;
import java.lang.reflect.Type;
import java.util.Optional;
import org.apache.pulsar.common.schema.KeyValue;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class KeyValueFromPulsarMessageKeyValueExtractor
implements KeyValueExtractor {
    public boolean canExtract(Message<?> message, Type keyType, Type valueType) {
        Optional metadata = message.getMetadata(PulsarIncomingMessageMetadata.class);
        return metadata.filter(incomingMetadata -> message.getPayload() instanceof KeyValue && TypeUtils.isAssignable((Type)keyType, ((KeyValue)message.getPayload()).getKey().getClass()) && TypeUtils.isAssignable((Type)valueType, ((KeyValue)message.getPayload()).getValue().getClass())).isPresent();
    }

    public Object extractKey(Message<?> message, Type keyType) {
        return ((KeyValue)message.getPayload()).getKey();
    }

    public Object extractValue(Message<?> message, Type valueType) {
        return ((KeyValue)message.getPayload()).getValue();
    }
}

