/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar.tracing;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import io.smallrye.reactive.messaging.pulsar.tracing.PulsarTrace;

public class PulsarAttributesExtractor
implements AttributesExtractor<PulsarTrace, Void> {
    private final MessagingAttributesGetter<PulsarTrace, Void> messagingAttributesGetter = new PulsarMessagingAttributesGetter();

    public void onStart(AttributesBuilder attributes, Context parentContext, PulsarTrace pulsarTrace) {
        String consumerName = pulsarTrace.getConsumerName();
        attributes.put(SemanticAttributes.MESSAGING_CONSUMER_ID, (Object)consumerName);
    }

    public void onEnd(AttributesBuilder attributes, Context context, PulsarTrace pulsarTrace, Void unused, Throwable error) {
    }

    public MessagingAttributesGetter<PulsarTrace, Void> getMessagingAttributesGetter() {
        return this.messagingAttributesGetter;
    }

    private static final class PulsarMessagingAttributesGetter
    implements MessagingAttributesGetter<PulsarTrace, Void> {
        private PulsarMessagingAttributesGetter() {
        }

        public String getSystem(PulsarTrace pulsarTrace) {
            return "pulsar";
        }

        public String getDestination(PulsarTrace pulsarTrace) {
            return pulsarTrace.getTopic();
        }

        public boolean isTemporaryDestination(PulsarTrace pulsarTrace) {
            return false;
        }

        public String getConversationId(PulsarTrace pulsarTrace) {
            return null;
        }

        public Long getMessagePayloadSize(PulsarTrace pulsarTrace) {
            return null;
        }

        public Long getMessagePayloadCompressedSize(PulsarTrace pulsarTrace) {
            return pulsarTrace.getUncompressedPayloadSize();
        }

        public String getMessageId(PulsarTrace pulsarTrace, Void unused) {
            return pulsarTrace.getMessageId();
        }
    }
}

