package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.Class;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.Throwable;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;

/**
 * Automatically generated from the {@link CircuitBreakerConfig} config interface, do not modify.
 */
public final class CircuitBreakerConfigImpl implements CircuitBreakerConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final CircuitBreaker instance;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Cached value of the {@code CircuitBreaker.failOn} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends Throwable>[] _failOn;

    /**
     * Cached value of the {@code CircuitBreaker.skipOn} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends Throwable>[] _skipOn;

    /**
     * Cached value of the {@code CircuitBreaker.delay} annotation member; {@code null} if not looked up yet.
     */
    private Long _delay;

    /**
     * Cached value of the {@code CircuitBreaker.delayUnit} annotation member; {@code null} if not looked up yet.
     */
    private ChronoUnit _delayUnit;

    /**
     * Cached value of the {@code CircuitBreaker.requestVolumeThreshold} annotation member; {@code null} if not looked up yet.
     */
    private Integer _requestVolumeThreshold;

    /**
     * Cached value of the {@code CircuitBreaker.failureRatio} annotation member; {@code null} if not looked up yet.
     */
    private Double _failureRatio;

    /**
     * Cached value of the {@code CircuitBreaker.successThreshold} annotation member; {@code null} if not looked up yet.
     */
    private Integer _successThreshold;

    private CircuitBreakerConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.circuitBreaker;
        this.onMethod = method.annotationsPresentDirectly.contains(CircuitBreaker.class);
    }

    public static CircuitBreakerConfigImpl create(FaultToleranceMethod method) {
        if (method.circuitBreaker == null) {
            return null;
        }
        if (!Config.isEnabled(CircuitBreaker.class, method.method)) {
            return null;
        }
        return new CircuitBreakerConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return CircuitBreaker.class;
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public Class<? extends Throwable>[] failOn() {
        if (_failOn == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                _failOn = config.getOptionalValue(getConfigKeyForMethod("failOn"), Class[].class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                _failOn = config.getOptionalValue(getConfigKeyForClass("failOn"), Class[].class).orElse(null);
            }
            if (_failOn == null) {
                // <annotation>/<parameter>
                _failOn = config.getOptionalValue("CircuitBreaker" + "/" + "failOn", Class[].class).orElse(null);
            }
            if (_failOn == null) {
                // annotation value
                _failOn = instance.failOn();
            }
        }
        return _failOn;
    }

    @Override
    public Class<? extends Throwable>[] skipOn() {
        if (_skipOn == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                _skipOn = config.getOptionalValue(getConfigKeyForMethod("skipOn"), Class[].class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                _skipOn = config.getOptionalValue(getConfigKeyForClass("skipOn"), Class[].class).orElse(null);
            }
            if (_skipOn == null) {
                // <annotation>/<parameter>
                _skipOn = config.getOptionalValue("CircuitBreaker" + "/" + "skipOn", Class[].class).orElse(null);
            }
            if (_skipOn == null) {
                // annotation value
                _skipOn = instance.skipOn();
            }
        }
        return _skipOn;
    }

    @Override
    public long delay() {
        if (_delay == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                _delay = config.getOptionalValue(getConfigKeyForMethod("delay"), long.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                _delay = config.getOptionalValue(getConfigKeyForClass("delay"), long.class).orElse(null);
            }
            if (_delay == null) {
                // <annotation>/<parameter>
                _delay = config.getOptionalValue("CircuitBreaker" + "/" + "delay", long.class).orElse(null);
            }
            if (_delay == null) {
                // annotation value
                _delay = instance.delay();
            }
        }
        return _delay;
    }

    @Override
    public ChronoUnit delayUnit() {
        if (_delayUnit == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                _delayUnit = config.getOptionalValue(getConfigKeyForMethod("delayUnit"), ChronoUnit.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                _delayUnit = config.getOptionalValue(getConfigKeyForClass("delayUnit"), ChronoUnit.class).orElse(null);
            }
            if (_delayUnit == null) {
                // <annotation>/<parameter>
                _delayUnit = config.getOptionalValue("CircuitBreaker" + "/" + "delayUnit", ChronoUnit.class).orElse(null);
            }
            if (_delayUnit == null) {
                // annotation value
                _delayUnit = instance.delayUnit();
            }
        }
        return _delayUnit;
    }

    @Override
    public int requestVolumeThreshold() {
        if (_requestVolumeThreshold == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                _requestVolumeThreshold = config.getOptionalValue(getConfigKeyForMethod("requestVolumeThreshold"), int.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                _requestVolumeThreshold = config.getOptionalValue(getConfigKeyForClass("requestVolumeThreshold"), int.class).orElse(null);
            }
            if (_requestVolumeThreshold == null) {
                // <annotation>/<parameter>
                _requestVolumeThreshold = config.getOptionalValue("CircuitBreaker" + "/" + "requestVolumeThreshold", int.class).orElse(null);
            }
            if (_requestVolumeThreshold == null) {
                // annotation value
                _requestVolumeThreshold = instance.requestVolumeThreshold();
            }
        }
        return _requestVolumeThreshold;
    }

    @Override
    public double failureRatio() {
        if (_failureRatio == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                _failureRatio = config.getOptionalValue(getConfigKeyForMethod("failureRatio"), double.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                _failureRatio = config.getOptionalValue(getConfigKeyForClass("failureRatio"), double.class).orElse(null);
            }
            if (_failureRatio == null) {
                // <annotation>/<parameter>
                _failureRatio = config.getOptionalValue("CircuitBreaker" + "/" + "failureRatio", double.class).orElse(null);
            }
            if (_failureRatio == null) {
                // annotation value
                _failureRatio = instance.failureRatio();
            }
        }
        return _failureRatio;
    }

    @Override
    public int successThreshold() {
        if (_successThreshold == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                _successThreshold = config.getOptionalValue(getConfigKeyForMethod("successThreshold"), int.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                _successThreshold = config.getOptionalValue(getConfigKeyForClass("successThreshold"), int.class).orElse(null);
            }
            if (_successThreshold == null) {
                // <annotation>/<parameter>
                _successThreshold = config.getOptionalValue("CircuitBreaker" + "/" + "successThreshold", int.class).orElse(null);
            }
            if (_successThreshold == null) {
                // annotation value
                _successThreshold = instance.successThreshold();
            }
        }
        return _successThreshold;
    }

    private String getConfigKeyForMethod(String key) {
        return method.declaringClass.getName() + "/" + method.name + "/" + "CircuitBreaker" + "/" + key;
    }

    private String getConfigKeyForClass(String key) {
        return method.declaringClass.getName() + "/" + "CircuitBreaker" + "/" + key;
    }
}
