package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.ExponentialBackoff;
import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.ConfigProvider;

/**
 * Automatically generated from the {@link ExponentialBackoffConfig} config interface, do not modify.
 */
public final class ExponentialBackoffConfigImpl implements ExponentialBackoffConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final ExponentialBackoff instance;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Cached value of the {@code ExponentialBackoff.factor} annotation member; {@code null} if not looked up yet.
     */
    private Integer _factor;

    /**
     * Cached value of the {@code ExponentialBackoff.maxDelay} annotation member; {@code null} if not looked up yet.
     */
    private Long _maxDelay;

    /**
     * Cached value of the {@code ExponentialBackoff.maxDelayUnit} annotation member; {@code null} if not looked up yet.
     */
    private ChronoUnit _maxDelayUnit;

    private ExponentialBackoffConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.exponentialBackoff;
        this.onMethod = method.annotationsPresentDirectly.contains(ExponentialBackoff.class);
    }

    public static ExponentialBackoffConfigImpl create(FaultToleranceMethod method) {
        if (method.exponentialBackoff == null) {
            return null;
        }
        if (!Config.isEnabled(ExponentialBackoff.class, method.method)) {
            return null;
        }
        return new ExponentialBackoffConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return ExponentialBackoff.class;
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public int factor() {
        if (_factor == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                _factor = config.getOptionalValue(getConfigKeyForMethod("factor"), int.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                _factor = config.getOptionalValue(getConfigKeyForClass("factor"), int.class).orElse(null);
            }
            if (_factor == null) {
                // <annotation>/<parameter>
                _factor = config.getOptionalValue("ExponentialBackoff" + "/" + "factor", int.class).orElse(null);
            }
            if (_factor == null) {
                // annotation value
                _factor = instance.factor();
            }
        }
        return _factor;
    }

    @Override
    public long maxDelay() {
        if (_maxDelay == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                _maxDelay = config.getOptionalValue(getConfigKeyForMethod("maxDelay"), long.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                _maxDelay = config.getOptionalValue(getConfigKeyForClass("maxDelay"), long.class).orElse(null);
            }
            if (_maxDelay == null) {
                // <annotation>/<parameter>
                _maxDelay = config.getOptionalValue("ExponentialBackoff" + "/" + "maxDelay", long.class).orElse(null);
            }
            if (_maxDelay == null) {
                // annotation value
                _maxDelay = instance.maxDelay();
            }
        }
        return _maxDelay;
    }

    @Override
    public ChronoUnit maxDelayUnit() {
        if (_maxDelayUnit == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                _maxDelayUnit = config.getOptionalValue(getConfigKeyForMethod("maxDelayUnit"), ChronoUnit.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                _maxDelayUnit = config.getOptionalValue(getConfigKeyForClass("maxDelayUnit"), ChronoUnit.class).orElse(null);
            }
            if (_maxDelayUnit == null) {
                // <annotation>/<parameter>
                _maxDelayUnit = config.getOptionalValue("ExponentialBackoff" + "/" + "maxDelayUnit", ChronoUnit.class).orElse(null);
            }
            if (_maxDelayUnit == null) {
                // annotation value
                _maxDelayUnit = instance.maxDelayUnit();
            }
        }
        return _maxDelayUnit;
    }

    private String getConfigKeyForMethod(String key) {
        return method.declaringClass.getName() + "/" + method.name + "/" + "ExponentialBackoff" + "/" + key;
    }

    private String getConfigKeyForClass(String key) {
        return method.declaringClass.getName() + "/" + "ExponentialBackoff" + "/" + key;
    }
}
