package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.RateLimit;
import io.smallrye.faulttolerance.api.RateLimitType;
import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.ConfigProvider;

/**
 * Automatically generated from the {@link RateLimitConfig} config interface, do not modify.
 */
public final class RateLimitConfigImpl implements RateLimitConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final RateLimit instance;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Cached value of the {@code RateLimit.value} annotation member; {@code null} if not looked up yet.
     */
    private Integer _value;

    /**
     * Cached value of the {@code RateLimit.window} annotation member; {@code null} if not looked up yet.
     */
    private Long _window;

    /**
     * Cached value of the {@code RateLimit.windowUnit} annotation member; {@code null} if not looked up yet.
     */
    private ChronoUnit _windowUnit;

    /**
     * Cached value of the {@code RateLimit.minSpacing} annotation member; {@code null} if not looked up yet.
     */
    private Long _minSpacing;

    /**
     * Cached value of the {@code RateLimit.minSpacingUnit} annotation member; {@code null} if not looked up yet.
     */
    private ChronoUnit _minSpacingUnit;

    /**
     * Cached value of the {@code RateLimit.type} annotation member; {@code null} if not looked up yet.
     */
    private RateLimitType _type;

    private RateLimitConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.rateLimit;
        this.onMethod = method.annotationsPresentDirectly.contains(RateLimit.class);
    }

    public static RateLimitConfigImpl create(FaultToleranceMethod method) {
        if (method.rateLimit == null) {
            return null;
        }
        if (!Config.isEnabled(RateLimit.class, method.method)) {
            return null;
        }
        return new RateLimitConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return RateLimit.class;
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public int value() {
        if (_value == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/RateLimit/value";
                _value = config.getOptionalValue(key, int.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/RateLimit/value";
                _value = config.getOptionalValue(key, int.class).orElse(null);
            }
            if (_value == null) {
                // <annotation>/<parameter>
                _value = config.getOptionalValue("RateLimit/value", int.class).orElse(null);
            }
            if (_value == null) {
                // annotation value
                _value = instance.value();
            }
        }
        return _value;
    }

    @Override
    public long window() {
        if (_window == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/RateLimit/window";
                _window = config.getOptionalValue(key, long.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/RateLimit/window";
                _window = config.getOptionalValue(key, long.class).orElse(null);
            }
            if (_window == null) {
                // <annotation>/<parameter>
                _window = config.getOptionalValue("RateLimit/window", long.class).orElse(null);
            }
            if (_window == null) {
                // annotation value
                _window = instance.window();
            }
        }
        return _window;
    }

    @Override
    public ChronoUnit windowUnit() {
        if (_windowUnit == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/RateLimit/windowUnit";
                _windowUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/RateLimit/windowUnit";
                _windowUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            }
            if (_windowUnit == null) {
                // <annotation>/<parameter>
                _windowUnit = config.getOptionalValue("RateLimit/windowUnit", ChronoUnit.class).orElse(null);
            }
            if (_windowUnit == null) {
                // annotation value
                _windowUnit = instance.windowUnit();
            }
        }
        return _windowUnit;
    }

    @Override
    public long minSpacing() {
        if (_minSpacing == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/RateLimit/minSpacing";
                _minSpacing = config.getOptionalValue(key, long.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/RateLimit/minSpacing";
                _minSpacing = config.getOptionalValue(key, long.class).orElse(null);
            }
            if (_minSpacing == null) {
                // <annotation>/<parameter>
                _minSpacing = config.getOptionalValue("RateLimit/minSpacing", long.class).orElse(null);
            }
            if (_minSpacing == null) {
                // annotation value
                _minSpacing = instance.minSpacing();
            }
        }
        return _minSpacing;
    }

    @Override
    public ChronoUnit minSpacingUnit() {
        if (_minSpacingUnit == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/RateLimit/minSpacingUnit";
                _minSpacingUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/RateLimit/minSpacingUnit";
                _minSpacingUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            }
            if (_minSpacingUnit == null) {
                // <annotation>/<parameter>
                _minSpacingUnit = config.getOptionalValue("RateLimit/minSpacingUnit", ChronoUnit.class).orElse(null);
            }
            if (_minSpacingUnit == null) {
                // annotation value
                _minSpacingUnit = instance.minSpacingUnit();
            }
        }
        return _minSpacingUnit;
    }

    @Override
    public RateLimitType type() {
        if (_type == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/RateLimit/type";
                _type = config.getOptionalValue(key, RateLimitType.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/RateLimit/type";
                _type = config.getOptionalValue(key, RateLimitType.class).orElse(null);
            }
            if (_type == null) {
                // <annotation>/<parameter>
                _type = config.getOptionalValue("RateLimit/type", RateLimitType.class).orElse(null);
            }
            if (_type == null) {
                // annotation value
                _type = instance.type();
            }
        }
        return _type;
    }

    @Override
    public void materialize() {
        value();
        window();
        windowUnit();
        minSpacing();
        minSpacingUnit();
        type();
    }
}
