/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.oauth;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.ObjectWriter;
import io.smallrye.openapi.runtime.io.extension.ExtensionWriter;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;

public class OAuthWriter {
    private OAuthWriter() {
    }

    public static void writeOAuthFlows(ObjectNode parent, OAuthFlows model) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject("flows");
        OAuthWriter.writeOAuthFlow(node, model.getImplicit(), "implicit");
        OAuthWriter.writeOAuthFlow(node, model.getPassword(), "password");
        OAuthWriter.writeOAuthFlow(node, model.getClientCredentials(), "clientCredentials");
        OAuthWriter.writeOAuthFlow(node, model.getAuthorizationCode(), "authorizationCode");
        ExtensionWriter.writeExtensions(node, model);
    }

    private static void writeOAuthFlow(ObjectNode parent, OAuthFlow model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        JsonUtil.stringProperty(node, "authorizationUrl", model.getAuthorizationUrl());
        JsonUtil.stringProperty(node, "tokenUrl", model.getTokenUrl());
        JsonUtil.stringProperty(node, "refreshUrl", model.getRefreshUrl());
        ObjectWriter.writeStringMap(node, model.getScopes(), "scopes");
        ExtensionWriter.writeExtensions(node, model);
    }
}

