/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.config;

import io.spring.javaformat.config.DefaultJavaFormatConfig;
import io.spring.javaformat.config.IndentationStyle;
import io.spring.javaformat.config.PropertiesJavaFormatConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

public interface JavaFormatConfig {
    public static final JavaFormatConfig TABS = new DefaultJavaFormatConfig(IndentationStyle.TABS);
    public static final JavaFormatConfig SPACES = new DefaultJavaFormatConfig(IndentationStyle.SPACES);
    public static final JavaFormatConfig DEFAULT = TABS;

    public IndentationStyle getIndentationStyle();

    public static JavaFormatConfig findFrom(Path path) {
        return JavaFormatConfig.findFrom(path != null ? path.toFile() : (File)null);
    }

    public static JavaFormatConfig findFrom(File file) {
        if (file != null && file.isFile()) {
            return JavaFormatConfig.findFrom(file.getParentFile());
        }
        try {
            while (file != null) {
                File candidate = new File(file, ".springjavaformatconfig");
                if (candidate.exists() && candidate.isFile()) {
                    return JavaFormatConfig.load(candidate);
                }
                file = file.getParentFile();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DEFAULT;
    }

    public static JavaFormatConfig load(File file) {
        try {
            return PropertiesJavaFormatConfig.load(file);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static JavaFormatConfig load(InputStream inputStream) {
        try {
            return PropertiesJavaFormatConfig.load(inputStream);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

