/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages.php;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.VendorExtendable;
import io.swagger.codegen.handlebars.helpers.ExtensionHelper;
import io.swagger.codegen.languages.DefaultCodegenConfig;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.File;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPhpCodegen
extends DefaultCodegenConfig {
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractPhpCodegen.class);
    public static final String VARIABLE_NAMING_CONVENTION = "variableNamingConvention";
    public static final String PACKAGE_PATH = "packagePath";
    public static final String SRC_BASE_PATH = "srcBasePath";
    protected String invokerPackage = "php";
    protected String packagePath = "php-base";
    protected String artifactVersion = null;
    protected String srcBasePath = "lib";
    protected String testBasePath = "test";
    protected String docsBasePath = "docs";
    protected String apiDirName = "Api";
    protected String modelDirName = "Model";
    protected String variableNamingConvention = "snake_case";
    protected String apiDocPath = this.docsBasePath + File.separator + this.apiDirName;
    protected String modelDocPath = this.docsBasePath + File.separator + this.modelDirName;

    public AbstractPhpCodegen() {
        this.modelTemplateFiles.put("model.mustache", ".php");
        this.apiTemplateFiles.put("api.mustache", ".php");
        this.apiTestTemplateFiles.put("api_test.mustache", ".php");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.apiPackage = this.invokerPackage + "\\" + this.apiDirName;
        this.modelPackage = this.invokerPackage + "\\" + this.modelDirName;
        this.setReservedWordsLowerCase(Arrays.asList("resourcePath", "httpBody", "queryParams", "headerParams", "formParams", "_header_accept", "_tempBody", "__halt_compiler", "abstract", "and", "array", "as", "break", "callable", "case", "catch", "class", "clone", "const", "continue", "declare", "default", "die", "do", "echo", "else", "elseif", "empty", "enddeclare", "endfor", "endforeach", "endif", "endswitch", "endwhile", "eval", "exit", "extends", "final", "for", "foreach", "function", "global", "goto", "if", "implements", "include", "include_once", "instanceof", "insteadof", "interface", "isset", "list", "namespace", "new", "or", "print", "private", "protected", "public", "require", "require_once", "return", "static", "switch", "throw", "trait", "try", "unset", "use", "var", "while", "xor"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "boolean", "int", "integer", "double", "float", "string", "object", "DateTime", "mixed", "number", "void", "byte"));
        this.instantiationTypes.put("array", "array");
        this.instantiationTypes.put("map", "map");
        String primitives = "'" + StringUtils.join((Iterable)this.languageSpecificPrimitives, (String)"', '") + "'";
        this.additionalProperties.put("primitives", primitives);
        this.typeMapping = new HashMap();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("byte", "int");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("Date", "\\DateTime");
        this.typeMapping.put("DateTime", "\\DateTime");
        this.typeMapping.put("file", "\\SplFileObject");
        this.typeMapping.put("map", "map");
        this.typeMapping.put("array", "array");
        this.typeMapping.put("list", "array");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("UUID", "string");
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption(VARIABLE_NAMING_CONVENTION, "naming convention of variable name, e.g. camelCase.").defaultValue("snake_case"));
        this.cliOptions.add(new CliOption("invokerPackage", "The main namespace to use for all classes. e.g. Yay\\Pets"));
        this.cliOptions.add(new CliOption(PACKAGE_PATH, "The main package name for classes. e.g. GeneratedPetstore"));
        this.cliOptions.add(new CliOption(SRC_BASE_PATH, "The directory under packagePath to serve as source root."));
        this.cliOptions.add(new CliOption("gitUserId", "Git user ID, e.g. swagger-api."));
        this.cliOptions.add(new CliOption("gitRepoId", "Git repo ID, e.g. swagger-codegen."));
        this.cliOptions.add(new CliOption("artifactVersion", "The version to use in the composer package version field. e.g. 1.2.3"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(PACKAGE_PATH)) {
            this.setPackagePath((String)this.additionalProperties.get(PACKAGE_PATH));
        } else {
            this.additionalProperties.put(PACKAGE_PATH, this.packagePath);
        }
        if (this.additionalProperties.containsKey(SRC_BASE_PATH)) {
            this.setSrcBasePath((String)this.additionalProperties.get(SRC_BASE_PATH));
        } else {
            this.additionalProperties.put(SRC_BASE_PATH, this.srcBasePath);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
        } else {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
        if (!this.additionalProperties.containsKey("modelPackage")) {
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        if (!this.additionalProperties.containsKey("apiPackage")) {
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        if (this.additionalProperties.containsKey("gitUserId")) {
            this.setGitUserId((String)this.additionalProperties.get("gitUserId"));
        } else {
            this.additionalProperties.put("gitUserId", this.gitUserId);
        }
        if (this.additionalProperties.containsKey("gitRepoId")) {
            this.setGitRepoId((String)this.additionalProperties.get("gitRepoId"));
        } else {
            this.additionalProperties.put("gitRepoId", this.gitRepoId);
        }
        if (this.additionalProperties.containsKey("artifactVersion")) {
            this.setArtifactVersion((String)this.additionalProperties.get("artifactVersion"));
        } else {
            this.additionalProperties.put("artifactVersion", this.artifactVersion);
        }
        if (this.additionalProperties.containsKey(VARIABLE_NAMING_CONVENTION)) {
            this.setParameterNamingConvention((String)this.additionalProperties.get(VARIABLE_NAMING_CONVENTION));
        }
        this.additionalProperties.put("escapedInvokerPackage", this.invokerPackage.replace("\\", "\\\\"));
        this.additionalProperties.put("apiSrcPath", "." + File.separator + this.toSrcPath(this.apiPackage, this.srcBasePath));
        this.additionalProperties.put("modelSrcPath", "." + File.separator + this.toSrcPath(this.modelPackage, this.srcBasePath));
        this.additionalProperties.put("apiTestPath", "." + File.separator + this.testBasePath + File.separator + this.apiDirName);
        this.additionalProperties.put("modelTestPath", "." + File.separator + this.testBasePath + File.separator + this.modelDirName);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.additionalProperties.put("testBasePath", this.testBasePath);
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public String toPackagePath(String packageName, String basePath) {
        return this.getPackagePath() + File.separatorChar + this.toSrcPath(packageName, basePath);
    }

    public String toSrcPath(String packageName, String basePath) {
        packageName = packageName.replace(this.invokerPackage, "");
        if (basePath != null && basePath.length() > 0) {
            basePath = basePath.replaceAll("[\\\\/]?$", "") + File.separatorChar;
        }
        String regFirstPathSeparator = "/".equals(File.separator) ? "^/" : "^\\\\";
        String regLastPathSeparator = "/".equals(File.separator) ? "/$" : "\\\\$";
        return (basePath + packageName.replaceAll("[\\.\\\\/]", Matcher.quoteReplacement(File.separator)).replaceAll(regFirstPathSeparator, "")).replaceAll(regLastPathSeparator + "$", "");
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.toPackagePath(this.apiPackage, this.srcBasePath);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.toPackagePath(this.modelPackage, this.srcBasePath);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.getPackagePath() + File.separator + this.testBasePath + File.separator + this.apiDirName;
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.getPackagePath() + File.separator + this.testBasePath + File.separator + this.modelDirName;
    }

    @Override
    public String apiDocFileFolder() {
        return this.outputFolder + File.separator + this.getPackagePath() + File.separator + this.apiDocPath;
    }

    @Override
    public String modelDocFileFolder() {
        return this.outputFolder + File.separator + this.getPackagePath() + File.separator + this.modelDocPath;
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        if (propertySchema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)propertySchema;
            Schema inner = arraySchema.getItems();
            if (inner == null) {
                LOGGER.warn(arraySchema.getName() + "(array property) does not have a proper inner type defined");
                return "";
            }
            return this.getTypeDeclaration(inner) + "[]";
        }
        if (propertySchema instanceof MapSchema) {
            MapSchema mapSchema = (MapSchema)propertySchema;
            Schema inner = (Schema)mapSchema.getAdditionalProperties();
            if (inner == null) {
                LOGGER.warn(propertySchema.getName() + "(map property) does not have a proper inner type defined");
                return "";
            }
            return this.getSchemaType(propertySchema) + "[string," + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(propertySchema);
    }

    @Override
    public String getTypeDeclaration(String name) {
        if (!this.languageSpecificPrimitives.contains(name)) {
            return "\\" + this.modelPackage + "\\" + name;
        }
        return super.getTypeDeclaration(name);
    }

    @Override
    public String getSchemaType(Schema property) {
        String schemaType = super.getSchemaType(property);
        String type = null;
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
            if (this.instantiationTypes.containsKey(type)) {
                return type;
            }
        } else {
            type = schemaType;
        }
        if (type == null) {
            return null;
        }
        return this.toModelName(type);
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public void setPackagePath(String packagePath) {
        this.packagePath = packagePath;
    }

    public void setSrcBasePath(String srcBasePath) {
        this.srcBasePath = srcBasePath;
    }

    public void setParameterNamingConvention(String variableNamingConvention) {
        this.variableNamingConvention = variableNamingConvention;
    }

    @Override
    public String toVarName(String name) {
        name = this.sanitizeName(name);
        name = "camelCase".equals(this.variableNamingConvention) ? AbstractPhpCodegen.camelize(name, true) : AbstractPhpCodegen.underscore(name);
        if (name.matches("^\\d.*")) {
            name = "_" + name;
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        name = name.replaceAll("\\]", "");
        name = name.replaceAll("[^\\w\\\\]+", "_");
        if (this.isReservedWord(name = name.replaceAll("$", ""))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + AbstractPhpCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + AbstractPhpCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        if (!name.matches("^\\\\.*")) {
            name = this.modelNamePrefix + name + this.modelNameSuffix;
        }
        return AbstractPhpCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelName(name) + "Test";
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + AbstractPhpCodegen.camelize(this.sanitizeName("call_" + operationId), true));
            operationId = "call_" + operationId;
        }
        return AbstractPhpCodegen.camelize(this.sanitizeName(operationId), true);
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (schema instanceof StringSchema) {
            StringSchema stringSchema = (StringSchema)schema;
            if (stringSchema.getDefault() != null) {
                return "'" + (String)stringSchema.getDefault() + "'";
            }
        } else if (schema instanceof BooleanSchema) {
            BooleanSchema booleanSchema = (BooleanSchema)schema;
            if (booleanSchema.getDefault() != null) {
                return booleanSchema.getDefault().toString();
            }
        } else if (!(schema instanceof DateSchema) && !(schema instanceof DateTimeSchema)) {
            IntegerSchema integerSchema;
            if (schema instanceof NumberSchema) {
                NumberSchema numberSchema = (NumberSchema)schema;
                if (numberSchema.getDefault() != null && ("float".equals(schema.getFormat()) || "double".equals(schema.getFormat()))) {
                    return ((BigDecimal)numberSchema.getDefault()).toString();
                }
            } else if (schema instanceof IntegerSchema && (integerSchema = (IntegerSchema)schema).getDefault() != null) {
                return ((Number)integerSchema.getDefault()).toString();
            }
        }
        return null;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter) {
        String example = codegenParameter.defaultValue == null ? codegenParameter.example : codegenParameter.defaultValue;
        String type = codegenParameter.baseType;
        if (type == null) {
            type = codegenParameter.dataType;
        }
        if ("String".equalsIgnoreCase(type)) {
            if (example == null) {
                example = codegenParameter.paramName + "_example";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if ("Integer".equals(type) || "int".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("Float".equalsIgnoreCase(type) || "Double".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "3.4";
            }
        } else if ("BOOLEAN".equalsIgnoreCase(type) || "bool".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "True";
            }
        } else if ("\\SplFileObject".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if ("Date".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "new \\DateTime(\"" + this.escapeText(example) + "\")";
        } else if ("DateTime".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "new \\DateTime(\"" + this.escapeText(example) + "\")";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = "new " + this.getTypeDeclaration(type) + "()";
        } else {
            LOGGER.warn("Type " + type + " not handled properly in setParameterExampleValue");
        }
        boolean isListContainer = ExtensionHelper.getBooleanValue((VendorExtendable)codegenParameter, "x-is-list-container");
        boolean isMapContainer = ExtensionHelper.getBooleanValue((VendorExtendable)codegenParameter, "x-is-map-container");
        if (example == null) {
            example = "NULL";
        } else if (isListContainer) {
            example = "array(" + example + ")";
        } else if (isMapContainer) {
            example = "array('key' => " + example + ")";
        }
        codegenParameter.example = example;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return "'" + this.escapeText(value) + "'";
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "EMPTY";
        }
        if (this.getSymbolName(name) != null) {
            return this.getSymbolName(name).toUpperCase();
        }
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        String enumName = this.sanitizeName(AbstractPhpCodegen.underscore(name).toUpperCase());
        enumName = enumName.replaceFirst("^_", "");
        if ((enumName = enumName.replaceFirst("_$", "")).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = AbstractPhpCodegen.underscore(this.toModelName(property.name)).toUpperCase();
        if (enumName.matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            op.vendorExtensions.put("x-testOperationId", AbstractPhpCodegen.camelize(op.operationId));
        }
        return objs;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "");
    }

    protected String extractSimpleName(String phpClassName) {
        if (phpClassName == null) {
            return null;
        }
        int lastBackslashIndex = phpClassName.lastIndexOf(92);
        return phpClassName.substring(lastBackslashIndex + 1);
    }
}

