/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.controllers;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.io.Files;
import io.swagger.inflector.config.Configuration;
import io.swagger.inflector.config.ControllerFactory;
import io.swagger.inflector.converters.ConversionException;
import io.swagger.inflector.converters.InputConverter;
import io.swagger.inflector.examples.ExampleBuilder;
import io.swagger.inflector.examples.models.ArrayExample;
import io.swagger.inflector.examples.models.Example;
import io.swagger.inflector.examples.models.ObjectExample;
import io.swagger.inflector.models.ApiError;
import io.swagger.inflector.models.RequestContext;
import io.swagger.inflector.models.ResponseContext;
import io.swagger.inflector.processors.EntityProcessor;
import io.swagger.inflector.processors.EntityProcessorFactory;
import io.swagger.inflector.schema.SchemaValidator;
import io.swagger.inflector.utils.ApiErrorUtils;
import io.swagger.inflector.utils.ApiException;
import io.swagger.inflector.utils.ContentTypeSelector;
import io.swagger.inflector.utils.ReflectionUtils;
import io.swagger.inflector.validators.ValidationException;
import io.swagger.inflector.validators.ValidationMessage;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.Property;
import io.swagger.util.Json;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.glassfish.jersey.process.Inflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerOperationController
extends ReflectionUtils
implements Inflector<ContainerRequestContext, Response> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerOperationController.class);
    private static Set<String> commonHeaders = new HashSet<String>();
    private String path;
    private String httpMethod;
    private Operation operation;
    private Object controller = null;
    private Method method = null;
    private JavaType[] parameterClasses = null;
    private Map<String, Model> definitions;
    private InputConverter validator;
    private String controllerName;
    private String methodName;
    private String operationSignature;
    @Inject
    private Provider<Providers> providersProvider;
    @Inject
    private Provider<HttpServletRequest> requestProvider;
    @Inject
    private Provider<HttpServletResponse> responseProvider;
    private ControllerFactory controllerFactoryCache = null;

    public SwaggerOperationController(Configuration config, String path, String httpMethod, Operation operation, Map<String, Model> definitions) {
        this.setConfiguration(config);
        this.path = path;
        this.httpMethod = httpMethod;
        this.operation = operation;
        this.definitions = definitions;
        this.validator = InputConverter.getInstance();
        this.method = this.detectMethod(operation);
        if (this.method == null) {
            LOGGER.debug("no method `" + this.methodName + "` in `" + this.controllerName + "` to map to, using mock response");
        }
    }

    SwaggerOperationController(Configuration config, String path, String httpMethod, Operation operation, Map<String, Model> definitions, Provider<HttpServletRequest> requestProvider, Provider<HttpServletResponse> responseProvider) {
        this(config, path, httpMethod, operation, definitions);
        this.requestProvider = requestProvider;
        this.responseProvider = responseProvider;
    }

    public Method detectMethod(Operation operation) {
        this.controllerName = this.getControllerName(operation);
        this.methodName = this.getMethodName(this.path, this.httpMethod, operation);
        JavaType[] args = this.getOperationParameterClasses(operation, this.definitions);
        StringBuilder builder = new StringBuilder();
        builder.append(this.getMethodName(this.path, this.httpMethod, operation)).append("(");
        for (int i = 0; i < args.length; ++i) {
            if (i == 0) {
                builder.append(RequestContext.class.getCanonicalName()).append(" request");
                continue;
            }
            builder.append(", ");
            if (args[i] == null) {
                LOGGER.error("didn't expect a null class for " + ((Parameter)operation.getParameters().get(i - 1)).getName());
                continue;
            }
            if (args[i].getRawClass() == null) continue;
            String className = args[i].getRawClass().getName();
            if (className.startsWith("java.lang.")) {
                className = className.substring("java.lang.".length());
            }
            builder.append(className);
            builder.append(" ").append(((Parameter)operation.getParameters().get(i - 1)).getName());
        }
        builder.append(")");
        this.operationSignature = "public io.swagger.inflector.models.ResponseContext " + builder.toString();
        LOGGER.info("looking for method: `" + this.operationSignature + "` in class `" + this.controllerName + "`");
        this.parameterClasses = args;
        if (this.controllerName != null && this.methodName != null) {
            try {
                Method[] methods;
                Class<?> cls;
                try {
                    cls = Class.forName(this.controllerName);
                }
                catch (ClassNotFoundException e) {
                    this.controllerName = this.controllerName + "Controller";
                    cls = Class.forName(this.controllerName);
                }
                for (Method method : methods = cls.getMethods()) {
                    Class<?>[] methodArgs;
                    if (!this.methodName.equals(method.getName()) || (methodArgs = method.getParameterTypes()).length != args.length) continue;
                    int i = 0;
                    boolean matched = true;
                    if (!args[i].getRawClass().equals(methodArgs[i])) {
                        LOGGER.debug("failed to match " + args[i] + ", " + methodArgs[i]);
                        matched = false;
                    }
                    if (!matched) continue;
                    this.parameterClasses = args;
                    this.controller = this.getControllerFactory().instantiateController(cls, operation);
                    LOGGER.debug("found class `" + this.controllerName + "`");
                    return method;
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.debug("didn't find class " + this.controller);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response apply(ContainerRequestContext ctx) {
        io.swagger.models.Response responseSchema;
        List parameters = this.operation.getParameters();
        RequestContext requestContext = this.createContext(ctx);
        String path = ctx.getUriInfo().getPath();
        HashMap<String, HashMap<String, String>> formMap = new HashMap<String, HashMap<String, String>>();
        HashMap<String, File> inputStreams = new HashMap<String, File>();
        Object[] args = new Object[parameters.size() + 1];
        if (parameters != null) {
            Object in;
            void var11_16;
            int i = 0;
            args[i] = requestContext;
            ++i;
            ArrayList<ValidationMessage> missingParams = new ArrayList<ValidationMessage>();
            UriInfo uri = ctx.getUriInfo();
            Object var11_15 = null;
            String[] parts = null;
            HashSet<String> existingKeys = new HashSet<String>();
            Iterator x = uri.getQueryParameters().keySet().iterator();
            while (x.hasNext()) {
                existingKeys.add((String)x.next() + ": qp");
            }
            x = uri.getPathParameters().keySet().iterator();
            while (x.hasNext()) {
                existingKeys.add((String)x.next() + ": pp");
            }
            for (String string : ctx.getHeaders().keySet()) {
            }
            MediaType mt = requestContext.getMediaType();
            for (Parameter p : parameters) {
                HashMap<String, String> headers = new HashMap<String, String>();
                String name = null;
                if (!(p instanceof FormParameter) || var11_16 != null) continue;
                if (mt.isCompatible(MediaType.MULTIPART_FORM_DATA_TYPE)) {
                    String[] boundary = (String[])mt.getParameters().get("boundary");
                    if (boundary == null) continue;
                    try {
                        InputStream output = ctx.getEntityStream();
                        MultipartStream multipartStream = new MultipartStream(output, boundary.getBytes());
                        boolean nextPart = multipartStream.skipPreamble();
                        while (nextPart) {
                            String filename;
                            String header = multipartStream.readHeaders();
                            if (header != null) {
                                CSVFormat format = CSVFormat.DEFAULT.withDelimiter(';').withRecordSeparator("=");
                                CSVParser records = format.parse((Reader)new StringReader(header));
                                for (CSVRecord r : records) {
                                    for (int j = 0; j < r.size(); ++j) {
                                        String string = r.get(j);
                                        CSVParser outerString = CSVFormat.DEFAULT.withDelimiter('=').parse((Reader)new StringReader(string));
                                        for (CSVRecord outerKvPair : outerString) {
                                            if (outerKvPair.size() == 2) {
                                                String key = outerKvPair.get(0).trim();
                                                String value = outerKvPair.get(1).trim();
                                                if ("name".equals(key)) {
                                                    name = value;
                                                }
                                                headers.put(key, value);
                                                continue;
                                            }
                                            CSVParser innerString = CSVFormat.DEFAULT.withDelimiter(':').parse((Reader)new StringReader(string));
                                            for (CSVRecord innerKVPair : innerString) {
                                                if (innerKVPair.size() != 2) continue;
                                                String key = innerKVPair.get(0).trim();
                                                String value = innerKVPair.get(1).trim();
                                                if ("name".equals(key)) {
                                                    name = value;
                                                }
                                                headers.put(key, value);
                                            }
                                        }
                                        if (name == null) continue;
                                        formMap.put(name, headers);
                                    }
                                }
                            }
                            if ((filename = SwaggerOperationController.extractFilenameFromHeaders(headers)) != null) {
                                try {
                                    File file = new File(Files.createTempDir(), filename);
                                    file.deleteOnExit();
                                    file.getParentFile().deleteOnExit();
                                    FileOutputStream fo = new FileOutputStream(file);
                                    multipartStream.readBodyData((OutputStream)fo);
                                    inputStreams.put(name, file);
                                }
                                catch (Exception e) {
                                    LOGGER.error("Failed to extract uploaded file", (Throwable)e);
                                }
                            } else {
                                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                                multipartStream.readBodyData((OutputStream)bo);
                                String value = bo.toString();
                                headers.put(name, value);
                            }
                            if (name != null) {
                                formMap.put(name, headers);
                            }
                            headers = new HashMap();
                            name = null;
                            nextPart = multipartStream.readBoundary();
                        }
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                try {
                    String string = IOUtils.toString((InputStream)ctx.getEntityStream(), (String)"UTF-8");
                    for (String part : parts = string.split("&")) {
                        String[] kv = part.split("=");
                        existingKeys.add(kv[0] + ": fp");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            for (Parameter parameter : parameters) {
                Object o;
                block112: {
                    in = parameter.getIn();
                    o = null;
                    try {
                        if ("formData".equals(in)) {
                            SerializableParameter sp = (SerializableParameter)parameter;
                            String name = parameter.getName();
                            if (mt.isCompatible(MediaType.MULTIPART_FORM_DATA_TYPE)) {
                                Map headers = (Map)formMap.get(name);
                                if (headers == null || headers.size() <= 0) break block112;
                                if ("file".equals(sp.getType())) {
                                    o = inputStreams.get(name);
                                    break block112;
                                }
                                Object obj = headers.get(parameter.getName());
                                if (obj != null) {
                                    JavaType jt = this.parameterClasses[i];
                                    Class cls = jt.getRawClass();
                                    List<String> os = Arrays.asList(obj.toString());
                                    try {
                                        o = this.validator.convertAndValidate(os, parameter, cls, this.definitions);
                                    }
                                    catch (ConversionException e) {
                                        missingParams.add(e.getError());
                                    }
                                    catch (ValidationException e) {
                                        missingParams.add(e.getValidationMessage());
                                    }
                                }
                                break block112;
                            }
                            if (var11_16 != null) {
                                for (String part : parts) {
                                    String[] kv = part.split("=");
                                    if (kv == null) continue;
                                    if (kv.length > 0) {
                                        existingKeys.remove(kv[0] + ": fp");
                                    }
                                    if (kv.length != 2) continue;
                                    String key = kv[0];
                                    try {
                                        String value = URLDecoder.decode(kv[1], "utf-8");
                                        if (!parameter.getName().equals(key)) continue;
                                        JavaType jt = this.parameterClasses[i];
                                        Class cls = jt.getRawClass();
                                        try {
                                            o = this.validator.convertAndValidate(Arrays.asList(value), parameter, cls, this.definitions);
                                        }
                                        catch (ConversionException e) {
                                            missingParams.add(e.getError());
                                        }
                                        catch (ValidationException e) {
                                            missingParams.add(e.getValidationMessage());
                                        }
                                    }
                                    catch (UnsupportedEncodingException e) {
                                        LOGGER.error("unable to decode value for " + key);
                                    }
                                }
                            }
                            break block112;
                        }
                        try {
                            String paramName = parameter.getName();
                            if ("query".equals(in)) {
                                existingKeys.remove(paramName + ": qp");
                            }
                            if ("path".equals(in)) {
                                existingKeys.remove(paramName + ": pp");
                            }
                            JavaType jt = this.parameterClasses[i];
                            Class cls = jt.getRawClass();
                            if ("body".equals(in)) {
                                if (ctx.hasEntity()) {
                                    BodyParameter body = (BodyParameter)parameter;
                                    o = EntityProcessorFactory.readValue(ctx.getMediaType(), ctx.getEntityStream(), cls);
                                    if (o != null) {
                                        this.validate(o, body.getSchema(), SchemaValidator.Direction.INPUT);
                                    }
                                } else if (parameter.getRequired()) {
                                    ValidationException e = new ValidationException();
                                    e.message(new ValidationMessage().message("The input body `" + paramName + "` is required"));
                                    throw e;
                                }
                            }
                            if ("query".equals(in)) {
                                o = this.validator.convertAndValidate((List)uri.getQueryParameters().get((Object)parameter.getName()), parameter, cls, this.definitions);
                                break block112;
                            }
                            if ("path".equals(in)) {
                                o = this.validator.convertAndValidate((List)uri.getPathParameters().get((Object)parameter.getName()), parameter, cls, this.definitions);
                            } else if ("header".equals(in)) {
                                o = this.validator.convertAndValidate((List)ctx.getHeaders().get((Object)parameter.getName()), parameter, cls, this.definitions);
                            }
                        }
                        catch (ConversionException e) {
                            missingParams.add(e.getError());
                        }
                        catch (ValidationException e) {
                            missingParams.add(e.getValidationMessage());
                        }
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Couldn't find " + parameter.getName() + " (" + (String)in + ") to " + this.parameterClasses[i], (Throwable)e);
                    }
                }
                args[i] = o;
                ++i;
            }
            if (existingKeys.size() > 0) {
                LOGGER.debug("unexpected keys: " + existingKeys);
            }
            if (missingParams.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Input error");
                if (missingParams.size() > 1) {
                    stringBuilder.append("s");
                }
                stringBuilder.append(": ");
                int count = 0;
                in = missingParams.iterator();
                while (true) {
                    if (!in.hasNext()) {
                        int statusCode = this.config.getInvalidRequestStatusCode();
                        ApiError error = new ApiError().code(statusCode).message(stringBuilder.toString());
                        throw new ApiException(error);
                    }
                    ValidationMessage message = (ValidationMessage)in.next();
                    if (count > 0) {
                        stringBuilder.append(", ");
                    }
                    if (message != null && message.getMessage() != null) {
                        stringBuilder.append(message.getMessage());
                    } else {
                        stringBuilder.append("no additional input");
                    }
                    ++count;
                }
            }
        }
        try {
            if (this.method != null) {
                ResponseContext wrapper;
                Object response;
                LOGGER.info("calling method " + this.method + " on controller " + this.controller + " with args " + Arrays.toString(args));
                try {
                    response = this.method.invoke(this.controller, args);
                    if (response instanceof ResponseContext) {
                        wrapper = (ResponseContext)response;
                        Response.ResponseBuilder builder = Response.status((int)wrapper.getStatus());
                        for (String key : wrapper.getHeaders().keySet()) {
                            List v = (List)wrapper.getHeaders().get((Object)key);
                            if (v.size() == 1) {
                                builder.header(key, v.get(0));
                                continue;
                            }
                            builder.header(key, (Object)v);
                        }
                        if (wrapper.getEntity() != null) {
                            builder.entity(wrapper.getEntity());
                            if (wrapper.getContentType() != null) {
                                builder.type(wrapper.getContentType());
                            } else {
                                ContextResolver contextResolver = ((Providers)this.providersProvider.get()).getContextResolver(ContentTypeSelector.class, MediaType.WILDCARD_TYPE);
                                if (contextResolver != null) {
                                    ((ContentTypeSelector)contextResolver.getContext(this.getClass())).apply(ctx.getAcceptableMediaTypes(), builder);
                                }
                            }
                            if (this.operation.getResponses() != null) {
                                String string = String.valueOf(wrapper.getStatus());
                                responseSchema = (io.swagger.models.Response)this.operation.getResponses().get(string);
                                if (responseSchema == null) {
                                    responseSchema = (io.swagger.models.Response)this.operation.getResponses().get("default");
                                }
                                if (responseSchema != null && responseSchema.getResponseSchema() != null) {
                                    this.validate(wrapper.getEntity(), responseSchema.getResponseSchema(), SchemaValidator.Direction.OUTPUT);
                                } else {
                                    LOGGER.debug("no response schema for code " + string + " to validate against");
                                }
                            }
                        }
                        Response response2 = builder.build();
                        return response2;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    while (cause != null) {
                        if (cause instanceof ApiException) {
                            throw (ApiException)cause;
                        }
                        Throwable next = cause.getCause();
                        cause = next == cause || next == null ? null : next;
                    }
                    throw new ApiException(ApiErrorUtils.createInternalError(), (Throwable)e);
                }
                wrapper = Response.ok().entity(response).build();
                return wrapper;
            }
            Map responses = this.operation.getResponses();
            if (responses != null) {
                Response.ResponseBuilder builder;
                void var11_31;
                String[] keys = new String[responses.keySet().size()];
                Arrays.sort(responses.keySet().toArray(keys));
                int code = 0;
                Object var11_26 = null;
                for (String string : keys) {
                    if (string.startsWith("2")) {
                        String string2 = string;
                        code = Integer.parseInt(string);
                        break;
                    }
                    if ("default".equals(string)) {
                        String string3 = string;
                        code = 200;
                        break;
                    }
                    if (!string.startsWith("3")) continue;
                    String string4 = string;
                    code = Integer.parseInt(string);
                }
                if (var11_31 != null) {
                    Example example;
                    Map examples;
                    builder = Response.status((int)code);
                    io.swagger.models.Response response = (io.swagger.models.Response)responses.get(var11_31);
                    if (response.getHeaders() != null && response.getHeaders().size() > 0) {
                        for (String string : response.getHeaders().keySet()) {
                            Property headerProperty = (Property)response.getHeaders().get(string);
                            Object output = ExampleBuilder.fromProperty(headerProperty, this.definitions);
                            if (output instanceof ArrayExample) {
                                output = ((ArrayExample)output).asString();
                            } else if (output instanceof ObjectExample) {
                                LOGGER.debug("not serializing output example, only primitives or arrays of primitives are supported");
                            } else {
                                output = ((Example)output).asString();
                            }
                            builder.header(string, output);
                        }
                    }
                    if ((examples = response.getExamples()) != null) {
                        for (MediaType mediaType : requestContext.getAcceptableMediaTypes()) {
                            for (String key : examples.keySet()) {
                                if (!MediaType.valueOf((String)key).isCompatible(mediaType)) continue;
                                builder.entity(examples.get(key)).type(mediaType);
                                Response e = builder.build();
                                return e;
                            }
                        }
                    }
                    if ((example = ExampleBuilder.fromProperty(response.getSchema(), this.definitions)) != null) {
                        ResponseContext resp = new ResponseContext().entity(example);
                        this.setContentType(requestContext, resp, this.operation);
                        builder.entity((Object)example);
                        if (resp.getContentType() != null) {
                            builder.type(resp.getContentType());
                        } else {
                            List<EntityProcessor> processors = EntityProcessorFactory.getProcessors();
                            MediaType responseMediaType = null;
                            block48: for (EntityProcessor processor : processors) {
                                if (responseMediaType != null) break;
                                for (MediaType mt : requestContext.getAcceptableMediaTypes()) {
                                    LOGGER.debug("checking type " + mt.toString() + " against " + processor.getClass().getName());
                                    if (!processor.supports(mt)) continue;
                                    builder.type(mt);
                                    responseMediaType = mt;
                                    continue block48;
                                }
                            }
                            if (responseMediaType == null) {
                                for (EntityProcessor processor : processors) {
                                    List<MediaType> supportedTypes = processor.getSupportedMediaTypes();
                                    if (supportedTypes.size() <= 0) continue;
                                    builder.type(supportedTypes.get(0));
                                    break;
                                }
                            }
                        }
                        builder.entity((Object)example);
                    }
                    Response response3 = builder.build();
                    return response3;
                }
                LOGGER.debug("no response type to map to, assume 200");
                code = 200;
                builder = Response.status((int)code).build();
                return builder;
            }
            Response response = Response.ok().build();
            return response;
        }
        finally {
            responseSchema = inputStreams.keySet().iterator();
            while (true) {
                if (!responseSchema.hasNext()) {
                }
                String key = (String)responseSchema.next();
                File file = (File)inputStreams.get(key);
                if (file == null) continue;
                LOGGER.debug("deleting file " + file.getPath());
                file.delete();
            }
        }
    }

    static String extractFilenameFromHeaders(Map<String, String> headers) {
        String filename = headers.get("filename");
        if (StringUtils.isBlank((String)filename)) {
            return null;
        }
        int ix = (filename = filename.trim()).lastIndexOf(File.separatorChar);
        if (ix != -1 && StringUtils.isBlank((String)(filename = filename.substring(ix + 1).trim()))) {
            return null;
        }
        return filename;
    }

    public void validate(Object o, Property property, SchemaValidator.Direction direction) throws ApiException {
        this.doValidation(o, property, direction);
    }

    public void validate(Object o, Model model, SchemaValidator.Direction direction) throws ApiException {
        this.doValidation(o, model, direction);
    }

    public void setContentType(RequestContext res, ResponseContext resp, Operation operation) {
        if (resp.getContentType() != null) {
            return;
        }
        List available = operation.getProduces();
        if (available != null) {
            for (String a : available) {
                MediaType mt = MediaType.valueOf((String)a);
                for (MediaType acceptable : res.getAcceptableMediaTypes()) {
                    if (!mt.isCompatible(acceptable)) continue;
                    resp.setContentType(mt);
                    return;
                }
            }
            if (available.size() > 0) {
                resp.setContentType(MediaType.valueOf((String)((String)available.get(0))));
            }
        }
    }

    public String getOperationSignature() {
        return this.operationSignature;
    }

    public void setOperationSignature(String operationSignature) {
        this.operationSignature = operationSignature;
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public void setControllerName(String controllerName) {
        this.controllerName = controllerName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    RequestContext createContext(ContainerRequestContext from) {
        HttpServletRequest request = this.getHttpServletRequest();
        HttpServletResponse response = this.getHttpServletResponse();
        return new RequestContext(from, request, response);
    }

    private HttpServletRequest getHttpServletRequest() {
        if (this.requestProvider != null) {
            return (HttpServletRequest)this.requestProvider.get();
        }
        LOGGER.warn("HttpServletRequest provider was null - returning null request!");
        return null;
    }

    private HttpServletResponse getHttpServletResponse() {
        if (this.responseProvider != null) {
            return (HttpServletResponse)this.responseProvider.get();
        }
        LOGGER.warn("HttpServletResponse provider was null - returning null response!");
        return null;
    }

    private void doValidation(Object value, Object schema, SchemaValidator.Direction direction) throws ApiException {
        if (this.config.getValidatePayloads().isEmpty()) {
            return;
        }
        switch (direction) {
            case INPUT: {
                if (!this.config.getValidatePayloads().contains((Object)Configuration.Direction.IN) || SchemaValidator.validate(value, Json.pretty((Object)schema), direction)) break;
                throw new ApiException(new ApiError().code(this.config.getInvalidRequestStatusCode()).message("Input does not match the expected structure"));
            }
            case OUTPUT: {
                if (!this.config.getValidatePayloads().contains((Object)Configuration.Direction.OUT) || SchemaValidator.validate(value, Json.pretty((Object)schema), direction)) break;
                throw new ApiException(new ApiError().code(this.config.getInvalidRequestStatusCode()).message("The server generated an invalid response"));
            }
        }
    }

    private ControllerFactory getControllerFactory() {
        if (this.controllerFactoryCache == null) {
            this.controllerFactoryCache = this.config.getControllerFactory();
        }
        return this.controllerFactoryCache;
    }

    static {
        commonHeaders.add("Host");
        commonHeaders.add("User-Agent");
        commonHeaders.add("Accept");
        commonHeaders.add("Content-Type");
        commonHeaders.add("Content-Length");
    }
}

