/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.processors;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.inflector.converters.ConversionException;
import io.swagger.inflector.processors.EntityProcessor;
import io.swagger.inflector.validators.ValidationError;
import io.swagger.inflector.validators.ValidationMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryProcessor
implements EntityProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinaryProcessor.class);
    private static List<MediaType> SUPPORTED_TYPES = new ArrayList<MediaType>();

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return new ArrayList<MediaType>(SUPPORTED_TYPES);
    }

    @Override
    public void enableType(MediaType type) {
        MediaType t = type;
        if (t != null && !SUPPORTED_TYPES.contains(t)) {
            SUPPORTED_TYPES.add(type);
        }
    }

    @Override
    public boolean supports(MediaType mediaType) {
        return SUPPORTED_TYPES.contains(mediaType);
    }

    @Override
    public Object process(MediaType mediaType, InputStream entityStream, Class<?> cls) throws ConversionException {
        try {
            return IOUtils.toByteArray((InputStream)entityStream);
        }
        catch (IOException e) {
            LOGGER.trace("unable to extract entity from content-type `" + mediaType + "` to byte[]", (Throwable)e);
            throw new ConversionException().message(new ValidationMessage().code(ValidationError.UNACCEPTABLE_VALUE).message("unable to convert input to " + cls.getCanonicalName()));
        }
    }

    @Override
    public Object process(MediaType mediaType, InputStream entityStream, JavaType javaType) {
        try {
            return IOUtils.toByteArray((InputStream)entityStream);
        }
        catch (IOException e) {
            LOGGER.error("unable to extract entity from content-type `" + mediaType + "` to byte[]", (Throwable)e);
            return null;
        }
    }

    static {
        SUPPORTED_TYPES.add(MediaType.APPLICATION_OCTET_STREAM_TYPE);
    }
}

