/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.utils;

import io.swagger.inflector.Constants;
import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.UntypedProperty;
import io.swagger.models.utils.PropertyModelConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolverUtil.class);
    private Map<String, Model> schemas;
    private Map<String, Model> resolvedModels = new HashMap<String, Model>();
    private Map<String, Property> resolvedProperties = new HashMap<String, Property>();

    public Map<String, Model> getResolvedModels() {
        return this.resolvedModels;
    }

    public void resolveFully(Swagger swagger) {
        if (swagger.getDefinitions() != null) {
            this.schemas = swagger.getDefinitions();
        }
        if (this.schemas == null) {
            this.schemas = new HashMap<String, Model>();
        }
        for (String name : this.schemas.keySet()) {
            ArrayModel am;
            Model model = this.schemas.get(name);
            if (model instanceof ModelImpl) {
                ModelImpl impl = (ModelImpl)model;
                if (impl.getVendorExtensions().containsKey(Constants.X_SWAGGER_ROUTER_MODEL)) continue;
                impl.setVendorExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)name);
                continue;
            }
            if (model instanceof ComposedModel) {
                ComposedModel cm = (ComposedModel)model;
                if (cm.getVendorExtensions().containsKey(Constants.X_SWAGGER_ROUTER_MODEL)) continue;
                cm.setVendorExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)name);
                continue;
            }
            if (!(model instanceof ArrayModel) || (am = (ArrayModel)model).getVendorExtensions().containsKey(Constants.X_SWAGGER_ROUTER_MODEL)) continue;
            am.setVendorExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)name);
        }
        if (swagger.getPaths() != null) {
            for (String pathname : swagger.getPaths().keySet()) {
                Path pathItem = (Path)swagger.getPaths().get(pathname);
                this.resolvePath(pathItem);
            }
        }
    }

    public void resolvePath(Path path) {
        for (Operation op : path.getOperations()) {
            for (Parameter parameter : op.getParameters()) {
                if (!(parameter instanceof BodyParameter)) continue;
                BodyParameter body = (BodyParameter)parameter;
                Model schema = body.getSchema();
                Model resolved = this.resolveModel(schema);
                body.setSchema(resolved);
            }
            if (op.getResponses() == null) continue;
            for (String code : op.getResponses().keySet()) {
                Response response = (Response)op.getResponses().get(code);
                if (response.getResponseSchema() == null) continue;
                Model resolved = this.resolveModel(response.getResponseSchema());
                response.setResponseSchema(resolved);
            }
        }
    }

    public Model resolveModel(Model schema) {
        ModelImpl model;
        if (schema instanceof RefModel) {
            String ref = ((RefModel)schema).getSimpleRef();
            Model resolved = this.schemas.get(ref);
            if (resolved == null) {
                LOGGER.error("unresolved model " + ref);
                return schema;
            }
            if (this.resolvedModels.containsKey(ref)) {
                LOGGER.debug("avoiding infinite loop");
                return this.resolvedModels.get(ref);
            }
            this.resolvedModels.put(ref, schema);
            Model model2 = this.resolveModel(resolved);
            this.resolvedModels.put(ref, model2);
            return model2;
        }
        if (schema instanceof ArrayModel) {
            ArrayModel arrayModel = (ArrayModel)schema;
            Property property = arrayModel.getItems();
            if (property instanceof RefProperty) {
                Property resolved = this.resolveProperty(property);
                arrayModel.setItems(resolved);
            }
            return arrayModel;
        }
        if (schema instanceof ModelImpl && (model = (ModelImpl)schema).getProperties() != null) {
            Property property;
            LinkedHashMap<String, Property> updated = new LinkedHashMap<String, Property>();
            for (String propertyName : model.getProperties().keySet()) {
                property = (Property)model.getProperties().get(propertyName);
                Property resolved = this.resolveProperty(property);
                updated.put(propertyName, resolved);
            }
            for (String key : updated.keySet()) {
                property = (Property)updated.get(key);
                if (!(property instanceof ObjectProperty)) continue;
                ObjectProperty op = (ObjectProperty)property;
                if (op.getProperties() != model.getProperties()) {
                    model.addProperty(key, property);
                    continue;
                }
                LOGGER.debug("not adding recursive properties, using generic object");
                model.addProperty(key, (Property)new ObjectProperty());
            }
            return model;
        }
        if (schema instanceof ComposedModel) {
            ComposedModel composedSchema = (ComposedModel)schema;
            ModelImpl model3 = new ModelImpl();
            HashSet<String> requiredProperties = new HashSet<String>();
            if (composedSchema.getAllOf() != null) {
                for (Model innerModel : composedSchema.getAllOf()) {
                    Model resolved = this.resolveModel(innerModel);
                    Map properties = resolved.getProperties();
                    if (resolved.getProperties() != null) {
                        for (String key : properties.keySet()) {
                            Property property = (Property)resolved.getProperties().get(key);
                            if (property.getRequired()) {
                                requiredProperties.add(key);
                            }
                            model3.addProperty(key, this.resolveProperty(property));
                        }
                    }
                    if (requiredProperties.size() > 0) {
                        model3.setRequired(new ArrayList(requiredProperties));
                    }
                    if (composedSchema.getVendorExtensions() == null) continue;
                    Map extensions = composedSchema.getVendorExtensions();
                    for (String key : extensions.keySet()) {
                        model3.setVendorExtension(key, composedSchema.getVendorExtensions().get(key));
                    }
                }
            }
            return model3;
        }
        LOGGER.error("no type match for " + schema);
        return schema;
    }

    private Property resolveProperty(Property property) {
        if (property instanceof RefProperty) {
            String ref = ((RefProperty)property).getSimpleRef();
            Model resolved = this.schemas.get(ref);
            if (resolved == null) {
                LOGGER.error("unresolved model " + ref);
                return property;
            }
            if (this.resolvedModels.containsKey(ref) || this.resolvedProperties.containsKey(ref)) {
                LOGGER.debug("avoiding infinite loop");
                Model modelResolved = this.resolvedModels.get(ref);
                Property propertyResolved = this.resolvedProperties.get(ref);
                if (modelResolved != null) {
                    PropertyModelConverter converter = new PropertyModelConverter();
                    Property convertedProperty = converter.modelToProperty(modelResolved);
                    if (convertedProperty instanceof UntypedProperty && modelResolved instanceof ModelImpl) {
                        Property property1 = this.createObjectProperty(modelResolved);
                        this.resolvedProperties.put(ref, property1);
                        return property1;
                    }
                    return convertedProperty;
                }
                if (propertyResolved != null) {
                    return propertyResolved;
                }
            }
            this.resolvedProperties.put(ref, property);
            Model model = this.resolveModel(resolved);
            this.resolvedModels.put(ref, model);
            PropertyModelConverter converter = new PropertyModelConverter();
            Property prop = converter.modelToProperty(model);
            if (prop instanceof UntypedProperty && model instanceof ModelImpl) {
                Property property1 = this.createObjectProperty(model);
                this.resolvedProperties.put(ref, property1);
                return property1;
            }
            return prop;
        }
        if (property instanceof ObjectProperty) {
            ObjectProperty obj = (ObjectProperty)property;
            if (obj.getProperties() != null) {
                LinkedHashMap<String, Property> updated = new LinkedHashMap<String, Property>();
                for (String propertyName : obj.getProperties().keySet()) {
                    Property innerProperty = (Property)obj.getProperties().get(propertyName);
                    if (property == innerProperty) continue;
                    Property resolved = this.resolveProperty(innerProperty);
                    updated.put(propertyName, resolved);
                }
                obj.setProperties(updated);
            }
            return obj;
        }
        if (property instanceof ArrayProperty) {
            ArrayProperty array = (ArrayProperty)property;
            if (array.getItems() != null) {
                Property resolved = this.resolveProperty(array.getItems());
                array.setItems(resolved);
            }
            return array;
        }
        return property;
    }

    public Property createObjectProperty(Model model) {
        if (model instanceof ModelImpl) {
            String name;
            ModelImpl m = (ModelImpl)model;
            ObjectProperty property = new ObjectProperty();
            property.setProperties(m.getProperties());
            property.setName(m.getName());
            property.setFormat(m.getFormat());
            if (m.getDefaultValue() != null) {
                property.setDefault(m.getDefaultValue().toString());
            }
            property.setDescription(m.getDescription());
            property.setXml(m.getXml());
            if (m.getExample() != null) {
                property.setExample(m.getExample().toString());
            }
            if ((name = (String)m.getVendorExtensions().get(Constants.X_SWAGGER_ROUTER_MODEL)) != null) {
                property.setVendorExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)name);
            }
            return property;
        }
        if (model instanceof ArrayModel) {
            ArrayModel m = (ArrayModel)model;
            ArrayProperty property = new ArrayProperty();
            Property inner = m.getItems();
            Property resolved = this.resolveProperty(inner);
            property.setItems(resolved);
            property.setDescription(m.getDescription());
            return property;
        }
        if (model instanceof RefModel) {
            RefModel ref = (RefModel)model;
            Model inner = this.schemas.get(ref.getSimpleRef());
            return this.createObjectProperty(inner);
        }
        if (model instanceof ComposedModel) {
            ObjectProperty op = new ObjectProperty();
            ComposedModel cm = (ComposedModel)model;
            HashSet<String> requiredProperties = new HashSet<String>();
            for (Model item : cm.getAllOf()) {
                Property itemProperty = this.createObjectProperty(item);
                if (!(itemProperty instanceof ObjectProperty)) continue;
                ObjectProperty itemPropertyObject = (ObjectProperty)itemProperty;
                if (itemPropertyObject.getProperties() != null) {
                    for (String key : itemPropertyObject.getProperties().keySet()) {
                        op.property(key, (Property)itemPropertyObject.getProperties().get(key));
                    }
                }
                if (itemPropertyObject.getRequiredProperties() == null) continue;
                for (String req : itemPropertyObject.getRequiredProperties()) {
                    requiredProperties.add(req);
                }
            }
            if (requiredProperties.size() > 0) {
                op.setRequiredProperties(new ArrayList(requiredProperties));
            }
            if (cm.getVendorExtensions() != null) {
                for (String key : cm.getVendorExtensions().keySet()) {
                    op.vendorExtension(key, cm.getVendorExtensions().get(key));
                }
            }
            return op;
        }
        LOGGER.error("can't resolve " + model);
        return null;
    }
}

