/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.utils;

import io.swagger.core.filter.SpecFilter;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.inflector.Constants;
import io.swagger.model.ApiDescription;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import java.util.List;
import java.util.Map;

public class VendorSpecFilter
extends SpecFilter {
    public Map<String, Model> filterDefinitions(SwaggerSpecFilter filter, Map<String, Model> definitions, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        Map filteredDefinitions = super.filterDefinitions(filter, definitions, params, cookies, headers);
        if (filteredDefinitions != null) {
            for (Model model : filteredDefinitions.values()) {
                this.filterVendorExtensions(model.getVendorExtensions());
            }
        }
        return filteredDefinitions;
    }

    public Operation filterOperation(SwaggerSpecFilter filter, Operation op, ApiDescription api, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        Operation operation = super.filterOperation(filter, op, api, params, cookies, headers);
        this.filterVendorExtensions(operation.getVendorExtensions());
        return operation;
    }

    private void filterVendorExtensions(Map<String, Object> vendorExtensions) {
        for (Constants.VendorExtension vendorExtension : Constants.VendorExtension.values()) {
            vendorExtensions.remove(vendorExtension.getValue());
        }
    }
}

