/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.auth.webauthn.AttestationCertificates;
import io.vertx.ext.auth.webauthn.Authenticator;
import java.util.Base64;
import java.util.Map;

public class AuthenticatorConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, Authenticator obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "aaguid": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAaguid((String)member.getValue());
                    break;
                }
                case "attestationCertificates": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setAttestationCertificates(new AttestationCertificates((JsonObject)member.getValue()));
                    break;
                }
                case "counter": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setCounter(((Number)member.getValue()).longValue());
                    break;
                }
                case "credID": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCredID((String)member.getValue());
                    break;
                }
                case "flags": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setFlags(((Number)member.getValue()).intValue());
                    break;
                }
                case "fmt": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setFmt((String)member.getValue());
                    break;
                }
                case "publicKey": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPublicKey((String)member.getValue());
                    break;
                }
                case "type": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setType((String)member.getValue());
                    break;
                }
                case "userName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUserName((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(Authenticator obj, JsonObject json) {
        AuthenticatorConverter.toJson(obj, json.getMap());
    }

    public static void toJson(Authenticator obj, Map<String, Object> json) {
        if (obj.getAaguid() != null) {
            json.put("aaguid", obj.getAaguid());
        }
        if (obj.getAttestationCertificates() != null) {
            json.put("attestationCertificates", obj.getAttestationCertificates().toJson());
        }
        json.put("counter", obj.getCounter());
        if (obj.getCredID() != null) {
            json.put("credID", obj.getCredID());
        }
        json.put("flags", obj.getFlags());
        if (obj.getFmt() != null) {
            json.put("fmt", obj.getFmt());
        }
        if (obj.getPublicKey() != null) {
            json.put("publicKey", obj.getPublicKey());
        }
        if (obj.getType() != null) {
            json.put("type", obj.getType());
        }
        if (obj.getUserName() != null) {
            json.put("userName", obj.getUserName());
        }
    }
}

