/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.arcgrid.raster;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class StringToDouble {
    private static final int CONVERTER_NUM = 50;
    static List pool = Collections.synchronizedList(new ArrayList(50));
    private double value = 0.0;
    private int prevCh = -1;
    private boolean eof = false;
    private final StringBuilder builder = new StringBuilder(30);

    private static void enlargePool(int num) {
        for (int i = 0; i < num; ++i) {
            pool.add(new SoftReference<StringToDouble>(new StringToDouble()));
        }
    }

    private StringToDouble() {
    }

    void reset() {
        this.value = 0.0;
        this.eof = false;
        this.prevCh = -1;
        this.builder.setLength(0);
    }

    boolean pushChar(int newChar) {
        boolean retVal = false;
        if (newChar != 32 && newChar != 10 && newChar != 13 && newChar != 9 && newChar != 0) {
            if (this.prevCh == 32 || this.prevCh == 10 || this.prevCh == 13 || this.prevCh == 9 || this.prevCh == 0) {
                retVal = true;
                this.value = this.compute();
                this.reset();
            }
            switch (newChar) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.builder.append(newChar - 48);
                    retVal = true;
                    break;
                }
                case 44: 
                case 46: {
                    this.builder.append('.');
                    retVal = true;
                    break;
                }
                case 45: {
                    this.builder.append('-');
                    retVal = true;
                    break;
                }
                case 43: {
                    this.builder.append('+');
                    retVal = true;
                    break;
                }
                case 42: {
                    retVal = true;
                    this.value = Double.NaN;
                    break;
                }
                case 69: 
                case 101: {
                    this.builder.append('E');
                    retVal = true;
                    break;
                }
                case -1: {
                    retVal = true;
                    this.eof = true;
                    break;
                }
                default: {
                    throw new NumberFormatException("Invalid data value was found. ASCII CODE : " + newChar);
                }
            }
        }
        this.prevCh = newChar;
        return retVal;
    }

    double compute() {
        if (!Double.isNaN(this.value)) {
            this.value = Double.parseDouble(this.builder.toString());
            this.builder.setLength(0);
        }
        return this.value;
    }

    boolean isEof() {
        return this.eof;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static StringToDouble acquire() {
        List list = pool;
        synchronized (list) {
            while (pool.size() > 0) {
                SoftReference r = (SoftReference)pool.remove(0);
                Object o = r.get();
                if (o == null) continue;
                StringToDouble stf = (StringToDouble)o;
                stf.reset();
                return stf;
            }
            StringToDouble.enlargePool(49);
            return new StringToDouble();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void release(StringToDouble c) {
        List list = pool;
        synchronized (list) {
            pool.add(new SoftReference<StringToDouble>(c));
        }
    }

    static {
        StringToDouble.enlargePool(50);
    }
}

