/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import it.geosolutions.imageio.gdalframework.GDALCreateOption;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class GDALCreateOptionsHandler {
    private final Map createOptionsMap = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCreateOptions() {
        Vector<String> options = new Vector<String>();
        Map map = this.createOptionsMap;
        synchronized (map) {
            Collection values = this.createOptionsMap.values();
            for (GDALCreateOption selectedOption : values) {
                if (!selectedOption.isSet()) continue;
                StringBuffer opt = new StringBuffer(selectedOption.getOptionName());
                if (selectedOption.getRepresentedValueType() != 55) {
                    opt.append("=").append(selectedOption.getValue());
                }
                options.add(opt.toString());
            }
        }
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCreateOption(String optionName, String optionValue) {
        Map map = this.createOptionsMap;
        synchronized (map) {
            if (!this.createOptionsMap.containsKey(optionName)) {
                throw new IllegalArgumentException("Create option with name" + optionName + " does not exist");
            }
            ((GDALCreateOption)this.createOptionsMap.get(optionName)).setValue(optionValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCreateOption(String optionName) {
        Map map = this.createOptionsMap;
        synchronized (map) {
            if (!this.createOptionsMap.containsKey(optionName)) {
                throw new IllegalArgumentException("Create option with name" + optionName + " does not exist");
            }
            ((GDALCreateOption)this.createOptionsMap.get(optionName)).setValue("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCreateOption(GDALCreateOption option) {
        if (option != null) {
            Map map = this.createOptionsMap;
            synchronized (map) {
                this.createOptionsMap.put(option.getOptionName(), option);
            }
        } else {
            throw new NullPointerException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCreateOptions(Collection options) {
        if (options != null && options.size() > 0) {
            Map map = this.createOptionsMap;
            synchronized (map) {
                for (Object o : options) {
                    if (o == null || !(o instanceof GDALCreateOption)) continue;
                    GDALCreateOption option = (GDALCreateOption)o;
                    this.createOptionsMap.put(option.getOptionName(), o);
                }
            }
        } else {
            throw new IllegalArgumentException("The provided collection is null or empty");
        }
    }

    public void setCreateOption(String optionName, int optionValue) {
        this.setCreateOption(optionName, Integer.toString(optionValue));
    }

    public void setCreateOption(String optionName, float optionValue) {
        this.setCreateOption(optionName, Float.toString(optionValue));
    }
}

