/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.util.ArrayList;
import jxl.Cell;
import jxl.CellType;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.ExternalSheet;
import jxl.read.biff.BaseSharedFormulaRecord;
import jxl.read.biff.Record;
import jxl.read.biff.SharedDateFormulaRecord;
import jxl.read.biff.SharedNumberFormulaRecord;
import jxl.read.biff.SheetImpl;

class SharedFormulaRecord {
    private int firstRow;
    private int lastRow;
    private int firstCol;
    private int lastCol;
    private BaseSharedFormulaRecord templateFormula;
    private ArrayList formulas;
    private byte[] tokens;
    private ExternalSheet externalSheet;
    private WorkbookMethods nameTable;
    private SheetImpl sheet;

    public SharedFormulaRecord(Record t, BaseSharedFormulaRecord fr, ExternalSheet es, WorkbookMethods nt, SheetImpl si) {
        this.externalSheet = es;
        this.nameTable = nt;
        this.sheet = si;
        byte[] data = t.getData();
        this.firstRow = IntegerHelper.getInt(data[0], data[1]);
        this.lastRow = IntegerHelper.getInt(data[2], data[3]);
        this.firstCol = data[4] & 0xFF;
        this.lastCol = data[5] & 0xFF;
        this.formulas = new ArrayList();
        this.templateFormula = fr;
        this.tokens = new byte[data.length - 10];
        System.arraycopy(data, 10, this.tokens, 0, this.tokens.length);
    }

    public boolean add(BaseSharedFormulaRecord fr) {
        if (fr.getRow() >= this.firstRow && fr.getRow() <= this.lastRow && fr.getColumn() >= this.firstCol && fr.getColumn() <= this.lastCol) {
            this.formulas.add(fr);
            return true;
        }
        return false;
    }

    Cell[] getFormulas(FormattingRecords fr, boolean nf) {
        Cell[] sfs = new Cell[this.formulas.size() + 1];
        if (this.templateFormula == null) {
            return new Cell[0];
        }
        this.templateFormula.setTokens(this.tokens);
        if (this.templateFormula.getType() == CellType.NUMBER_FORMULA && fr.isDate(this.templateFormula.getXFIndex())) {
            SharedNumberFormulaRecord snfr = (SharedNumberFormulaRecord)this.templateFormula;
            this.templateFormula = new SharedDateFormulaRecord(snfr, fr, nf, this.sheet, snfr.getFilePos());
            this.templateFormula.setTokens(snfr.getTokens());
        }
        sfs[0] = this.templateFormula;
        BaseSharedFormulaRecord f = null;
        for (int i = 0; i < this.formulas.size(); ++i) {
            f = (BaseSharedFormulaRecord)this.formulas.get(i);
            if (f.getType() == CellType.NUMBER_FORMULA && fr.isDate(f.getXFIndex())) {
                SharedNumberFormulaRecord snfr = (SharedNumberFormulaRecord)f;
                f = new SharedDateFormulaRecord(snfr, fr, nf, this.sheet, snfr.getFilePos());
            }
            f.setTokens(this.tokens);
            sfs[i + 1] = f;
        }
        return sfs;
    }
}

