/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.bytebuddy.matcher.ElementMatcher;

public class CollectionOneToOneMatcher<T>
extends ElementMatcher.Junction.AbstractBase<Iterable<? extends T>> {
    private final List<? extends ElementMatcher<? super T>> matchers;

    public CollectionOneToOneMatcher(List<? extends ElementMatcher<? super T>> matchers) {
        this.matchers = matchers;
    }

    @Override
    public boolean matches(Iterable<? extends T> target) {
        if (target instanceof Collection && ((Collection)target).size() != this.matchers.size()) {
            return false;
        }
        Iterator<ElementMatcher<T>> iterator = this.matchers.iterator();
        for (T value : target) {
            if (iterator.hasNext() && iterator.next().matches(value)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.matchers.equals(((CollectionOneToOneMatcher)other).matchers);
    }

    public int hashCode() {
        return this.matchers.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("containing(");
        boolean first = true;
        for (ElementMatcher<? super T> elementMatcher : this.matchers) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(elementMatcher);
        }
        return stringBuilder.append(")").toString();
    }
}

