/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.collection.ArrayAccess;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.DoubleConstant;
import net.bytebuddy.implementation.bytecode.constant.FloatConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.LongConstant;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.JavaConstant;
import net.bytebuddy.utility.JavaType;
import net.bytebuddy.utility.RandomString;

public class MethodCall
implements Implementation.Composable {
    protected final MethodLocator methodLocator;
    protected final TargetHandler targetHandler;
    protected final List<ArgumentLoader.Factory> argumentLoaders;
    protected final MethodInvoker methodInvoker;
    protected final TerminationHandler terminationHandler;
    protected final Assigner assigner;
    protected final Assigner.Typing typing;

    protected MethodCall(MethodLocator methodLocator, TargetHandler targetHandler, List<ArgumentLoader.Factory> argumentLoaders, MethodInvoker methodInvoker, TerminationHandler terminationHandler, Assigner assigner, Assigner.Typing typing) {
        this.methodLocator = methodLocator;
        this.targetHandler = targetHandler;
        this.argumentLoaders = argumentLoaders;
        this.methodInvoker = methodInvoker;
        this.terminationHandler = terminationHandler;
        this.assigner = assigner;
        this.typing = typing;
    }

    public static WithoutSpecifiedTarget invoke(Method method) {
        return MethodCall.invoke(new MethodDescription.ForLoadedMethod(method));
    }

    public static WithoutSpecifiedTarget invoke(Constructor<?> constructor) {
        return MethodCall.invoke(new MethodDescription.ForLoadedConstructor(constructor));
    }

    public static WithoutSpecifiedTarget invoke(MethodDescription methodDescription) {
        return MethodCall.invoke(new MethodLocator.ForExplicitMethod(methodDescription));
    }

    public static WithoutSpecifiedTarget invoke(ElementMatcher<? super MethodDescription> matcher) {
        return MethodCall.invoke(matcher, MethodGraph.Compiler.DEFAULT);
    }

    public static WithoutSpecifiedTarget invoke(ElementMatcher<? super MethodDescription> matcher, MethodGraph.Compiler methodGraphCompiler) {
        return MethodCall.invoke(new MethodLocator.ForElementMatcher(matcher, methodGraphCompiler));
    }

    public static WithoutSpecifiedTarget invoke(MethodLocator methodLocator) {
        return new WithoutSpecifiedTarget(methodLocator);
    }

    public static WithoutSpecifiedTarget invokeSelf() {
        return new WithoutSpecifiedTarget(MethodLocator.ForInstrumentedMethod.INSTANCE);
    }

    public static MethodCall invokeSuper() {
        return MethodCall.invokeSelf().onSuper();
    }

    public static Implementation.Composable call(Callable<?> callable) {
        try {
            return MethodCall.invoke(Callable.class.getMethod("call", new Class[0])).on(callable, Callable.class).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC);
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalStateException("Could not locate Callable::call method", exception);
        }
    }

    public static Implementation.Composable run(Runnable runnable) {
        try {
            return MethodCall.invoke(Runnable.class.getMethod("run", new Class[0])).on(runnable, Runnable.class).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC);
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalStateException("Could not locate Runnable::run method", exception);
        }
    }

    public static MethodCall construct(Constructor<?> constructor) {
        return MethodCall.construct(new MethodDescription.ForLoadedConstructor(constructor));
    }

    public static MethodCall construct(MethodDescription methodDescription) {
        if (!methodDescription.isConstructor()) {
            throw new IllegalArgumentException("Not a constructor: " + methodDescription);
        }
        return new MethodCall(new MethodLocator.ForExplicitMethod(methodDescription), TargetHandler.ForConstructingInvocation.INSTANCE, Collections.<ArgumentLoader.Factory>emptyList(), MethodInvoker.ForContextualInvocation.INSTANCE, TerminationHandler.RETURNING, Assigner.DEFAULT, Assigner.Typing.STATIC);
    }

    public MethodCall with(Object ... argument) {
        ArrayList<ArgumentLoader.Factory> argumentLoaders = new ArrayList<ArgumentLoader.Factory>(argument.length);
        for (Object anArgument : argument) {
            argumentLoaders.add(ArgumentLoader.ForInstance.Factory.of(anArgument));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall with(TypeDescription ... typeDescription) {
        ArrayList<ArgumentLoader.ForClassConstant> argumentLoaders = new ArrayList<ArgumentLoader.ForClassConstant>(typeDescription.length);
        for (TypeDescription aTypeDescription : typeDescription) {
            argumentLoaders.add(new ArgumentLoader.ForClassConstant(aTypeDescription));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall with(EnumerationDescription ... enumerationDescription) {
        ArrayList<ArgumentLoader.ForEnumerationValue> argumentLoaders = new ArrayList<ArgumentLoader.ForEnumerationValue>(enumerationDescription.length);
        for (EnumerationDescription anEnumerationDescription : enumerationDescription) {
            argumentLoaders.add(new ArgumentLoader.ForEnumerationValue(anEnumerationDescription));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall with(JavaConstant ... javaConstant) {
        ArrayList<ArgumentLoader.ForJavaConstant> argumentLoaders = new ArrayList<ArgumentLoader.ForJavaConstant>(javaConstant.length);
        for (JavaConstant aJavaConstant : javaConstant) {
            argumentLoaders.add(new ArgumentLoader.ForJavaConstant(aJavaConstant));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall withReference(Object ... argument) {
        ArrayList<ArgumentLoader.ForNullConstant> argumentLoaders = new ArrayList<ArgumentLoader.ForNullConstant>(argument.length);
        for (Object anArgument : argument) {
            argumentLoaders.add((ArgumentLoader.ForNullConstant)(anArgument == null ? ArgumentLoader.ForNullConstant.INSTANCE : new ArgumentLoader.ForInstance.Factory(anArgument)));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall withArgument(int ... index) {
        ArrayList<ArgumentLoader.ForMethodParameter.Factory> argumentLoaders = new ArrayList<ArgumentLoader.ForMethodParameter.Factory>(index.length);
        for (int anIndex : index) {
            if (anIndex < 0) {
                throw new IllegalArgumentException("Negative index: " + anIndex);
            }
            argumentLoaders.add(new ArgumentLoader.ForMethodParameter.Factory(anIndex));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall withAllArguments() {
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, ArgumentLoader.ForMethodParameter.OfInstrumentedMethod.INSTANCE), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall withArgumentArrayElements(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("A parameter index cannot be negative: " + index);
        }
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, new ArgumentLoader.ForMethodParameterArray.OfInvokedMethod(index)), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall withArgumentArrayElements(int index, int size) {
        return this.withArgumentArrayElements(index, 0, size);
    }

    public MethodCall withArgumentArrayElements(int index, int start, int size) {
        if (index < 0) {
            throw new IllegalArgumentException("A parameter index cannot be negative: " + index);
        }
        if (start < 0) {
            throw new IllegalArgumentException("An array index cannot be negative: " + start);
        }
        if (size == 0) {
            return this;
        }
        if (size < 0) {
            throw new IllegalArgumentException("Size cannot be negative: " + size);
        }
        ArrayList<ArgumentLoader.ForMethodParameterArray.OfParameter> argumentLoaders = new ArrayList<ArgumentLoader.ForMethodParameterArray.OfParameter>(size);
        for (int position = 0; position < size; ++position) {
            argumentLoaders.add(new ArgumentLoader.ForMethodParameterArray.OfParameter(index, start + position));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall withThis() {
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, ArgumentLoader.ForThisReference.Factory.INSTANCE), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall withOwnType() {
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, ArgumentLoader.ForInstrumentedType.Factory.INSTANCE), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public MethodCall withField(String ... name) {
        return this.withField(FieldLocator.ForClassHierarchy.Factory.INSTANCE, name);
    }

    public MethodCall withField(FieldLocator.Factory fieldLocatorFactory, String ... name) {
        ArrayList<ArgumentLoader.ForField.Factory> argumentLoaders = new ArrayList<ArgumentLoader.ForField.Factory>(name.length);
        for (String aFieldName : name) {
            argumentLoaders.add(new ArgumentLoader.ForField.Factory(aFieldName, fieldLocatorFactory));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public Implementation.Composable withAssigner(Assigner assigner, Assigner.Typing typing) {
        return new MethodCall(this.methodLocator, this.targetHandler, this.argumentLoaders, this.methodInvoker, this.terminationHandler, assigner, typing);
    }

    @Override
    public Implementation andThen(Implementation implementation) {
        return new Implementation.Compound(new MethodCall(this.methodLocator, this.targetHandler, this.argumentLoaders, this.methodInvoker, TerminationHandler.DROPPING, this.assigner, this.typing), implementation);
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        for (ArgumentLoader.Factory argumentLoader : this.argumentLoaders) {
            instrumentedType = argumentLoader.prepare(instrumentedType);
        }
        return this.targetHandler.prepare(instrumentedType);
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new Appender(implementationTarget);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodCall)) {
            return false;
        }
        MethodCall other = (MethodCall)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MethodLocator this$methodLocator = this.methodLocator;
        MethodLocator other$methodLocator = other.methodLocator;
        if (this$methodLocator == null ? other$methodLocator != null : !this$methodLocator.equals(other$methodLocator)) {
            return false;
        }
        TargetHandler this$targetHandler = this.targetHandler;
        TargetHandler other$targetHandler = other.targetHandler;
        if (this$targetHandler == null ? other$targetHandler != null : !this$targetHandler.equals(other$targetHandler)) {
            return false;
        }
        List<ArgumentLoader.Factory> this$argumentLoaders = this.argumentLoaders;
        List<ArgumentLoader.Factory> other$argumentLoaders = other.argumentLoaders;
        if (this$argumentLoaders == null ? other$argumentLoaders != null : !((Object)this$argumentLoaders).equals(other$argumentLoaders)) {
            return false;
        }
        MethodInvoker this$methodInvoker = this.methodInvoker;
        MethodInvoker other$methodInvoker = other.methodInvoker;
        if (this$methodInvoker == null ? other$methodInvoker != null : !this$methodInvoker.equals(other$methodInvoker)) {
            return false;
        }
        TerminationHandler this$terminationHandler = this.terminationHandler;
        TerminationHandler other$terminationHandler = other.terminationHandler;
        if (this$terminationHandler == null ? other$terminationHandler != null : !((Object)((Object)this$terminationHandler)).equals((Object)other$terminationHandler)) {
            return false;
        }
        Assigner this$assigner = this.assigner;
        Assigner other$assigner = other.assigner;
        if (this$assigner == null ? other$assigner != null : !this$assigner.equals(other$assigner)) {
            return false;
        }
        Assigner.Typing this$typing = this.typing;
        Assigner.Typing other$typing = other.typing;
        return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MethodCall;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MethodLocator $methodLocator = this.methodLocator;
        result = result * 59 + ($methodLocator == null ? 43 : $methodLocator.hashCode());
        TargetHandler $targetHandler = this.targetHandler;
        result = result * 59 + ($targetHandler == null ? 43 : $targetHandler.hashCode());
        List<ArgumentLoader.Factory> $argumentLoaders = this.argumentLoaders;
        result = result * 59 + ($argumentLoaders == null ? 43 : ((Object)$argumentLoaders).hashCode());
        MethodInvoker $methodInvoker = this.methodInvoker;
        result = result * 59 + ($methodInvoker == null ? 43 : $methodInvoker.hashCode());
        TerminationHandler $terminationHandler = this.terminationHandler;
        result = result * 59 + ($terminationHandler == null ? 43 : ((Object)((Object)$terminationHandler)).hashCode());
        Assigner $assigner = this.assigner;
        result = result * 59 + ($assigner == null ? 43 : $assigner.hashCode());
        Assigner.Typing $typing = this.typing;
        result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
        return result;
    }

    protected class Appender
    implements ByteCodeAppender {
        private final Implementation.Target implementationTarget;

        protected Appender(Implementation.Target implementationTarget) {
            this.implementationTarget = implementationTarget;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            MethodDescription invokedMethod = MethodCall.this.methodLocator.resolve(this.implementationTarget.getInstrumentedType(), instrumentedMethod);
            ArrayList<ArgumentLoader> argumentLoaders = new ArrayList<ArgumentLoader>(MethodCall.this.argumentLoaders.size());
            for (ArgumentLoader.Factory argumentLoader : MethodCall.this.argumentLoaders) {
                argumentLoaders.addAll(argumentLoader.make(this.implementationTarget.getInstrumentedType(), instrumentedMethod, invokedMethod));
            }
            ParameterList<?> parameters = invokedMethod.getParameters();
            Iterator parameterIterator = parameters.iterator();
            if (parameters.size() != argumentLoaders.size()) {
                throw new IllegalStateException(invokedMethod + " does not take " + argumentLoaders.size() + " arguments");
            }
            ArrayList<StackManipulation> argumentInstructions = new ArrayList<StackManipulation>(argumentLoaders.size());
            for (ArgumentLoader argumentLoader : argumentLoaders) {
                argumentInstructions.add(argumentLoader.resolve((ParameterDescription)parameterIterator.next(), MethodCall.this.assigner, MethodCall.this.typing));
            }
            StackManipulation.Size size = new StackManipulation.Compound(MethodCall.this.targetHandler.resolve(invokedMethod, instrumentedMethod, this.implementationTarget.getInstrumentedType(), MethodCall.this.assigner, MethodCall.this.typing), new StackManipulation.Compound(argumentInstructions), MethodCall.this.methodInvoker.invoke(invokedMethod, this.implementationTarget), MethodCall.this.terminationHandler.resolve(invokedMethod, instrumentedMethod, MethodCall.this.assigner, MethodCall.this.typing)).apply(methodVisitor, implementationContext);
            return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        private MethodCall getOuter() {
            return MethodCall.this;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Appender appender = (Appender)other;
            return this.implementationTarget.equals(appender.implementationTarget) && MethodCall.this.equals(appender.getOuter());
        }

        public int hashCode() {
            return this.implementationTarget.hashCode() + 31 * MethodCall.this.hashCode();
        }
    }

    public static class WithoutSpecifiedTarget
    extends MethodCall {
        protected WithoutSpecifiedTarget(MethodLocator methodLocator) {
            super(methodLocator, TargetHandler.ForSelfOrStaticInvocation.INSTANCE, Collections.<ArgumentLoader.Factory>emptyList(), MethodInvoker.ForContextualInvocation.INSTANCE, TerminationHandler.RETURNING, Assigner.DEFAULT, Assigner.Typing.STATIC);
        }

        public MethodCall on(Object target) {
            return this.on(target, target.getClass());
        }

        public <T> MethodCall on(T target, Class<? super T> type) {
            return new MethodCall(this.methodLocator, new TargetHandler.ForValue(target, new TypeDescription.Generic.OfNonGenericType.ForLoadedType(type)), this.argumentLoaders, new MethodInvoker.ForVirtualInvocation(type), this.terminationHandler, this.assigner, this.typing);
        }

        public MethodCall onArgument(int index) {
            if (index < 0) {
                throw new IllegalArgumentException("An argument index cannot be negative: " + index);
            }
            return new MethodCall(this.methodLocator, new TargetHandler.ForMethodParameter(index), this.argumentLoaders, MethodInvoker.ForVirtualInvocation.WithImplicitType.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }

        public MethodCall onField(String name) {
            return this.onField(name, FieldLocator.ForClassHierarchy.Factory.INSTANCE);
        }

        public MethodCall onField(String name, FieldLocator.Factory fieldLocatorFactory) {
            return new MethodCall(this.methodLocator, new TargetHandler.ForField(name, fieldLocatorFactory), this.argumentLoaders, MethodInvoker.ForVirtualInvocation.WithImplicitType.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }

        public MethodCall onSuper() {
            return new MethodCall(this.methodLocator, TargetHandler.ForSelfOrStaticInvocation.INSTANCE, this.argumentLoaders, MethodInvoker.ForSuperMethodInvocation.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }

        public MethodCall onDefault() {
            return new MethodCall(this.methodLocator, TargetHandler.ForSelfOrStaticInvocation.INSTANCE, this.argumentLoaders, MethodInvoker.ForDefaultMethodInvocation.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }
    }

    protected static enum TerminationHandler {
        RETURNING{

            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                StackManipulation stackManipulation = assigner.assign(invokedMethod.isConstructor() ? invokedMethod.getDeclaringType().asGenericType() : invokedMethod.getReturnType(), instrumentedMethod.getReturnType(), typing);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot return " + invokedMethod.getReturnType() + " from " + instrumentedMethod);
                }
                return new StackManipulation.Compound(stackManipulation, MethodReturn.of(instrumentedMethod.getReturnType()));
            }
        }
        ,
        DROPPING{

            @Override
            protected StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                return Removal.of(invokedMethod.isConstructor() ? invokedMethod.getDeclaringType() : invokedMethod.getReturnType());
            }
        };


        protected abstract StackManipulation resolve(MethodDescription var1, MethodDescription var2, Assigner var3, Assigner.Typing var4);
    }

    protected static interface MethodInvoker {
        public StackManipulation invoke(MethodDescription var1, Implementation.Target var2);

        public static enum ForDefaultMethodInvocation implements MethodInvoker
        {
            INSTANCE;


            @Override
            public StackManipulation invoke(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                if (!invokedMethod.isInvokableOn(implementationTarget.getInstrumentedType())) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " as default method of " + implementationTarget.getInstrumentedType());
                }
                Implementation.SpecialMethodInvocation stackManipulation = implementationTarget.invokeDefault(invokedMethod.asSignatureToken(), invokedMethod.getDeclaringType().asErasure());
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + implementationTarget.getInstrumentedType());
                }
                return stackManipulation;
            }
        }

        public static enum ForSuperMethodInvocation implements MethodInvoker
        {
            INSTANCE;


            @Override
            public StackManipulation invoke(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                if (implementationTarget.getInstrumentedType().getSuperClass() == null) {
                    throw new IllegalStateException("Cannot invoke super method for " + implementationTarget.getInstrumentedType());
                }
                if (!invokedMethod.isInvokableOn(implementationTarget.getOriginType().asErasure())) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " as super method of " + implementationTarget.getInstrumentedType());
                }
                Implementation.SpecialMethodInvocation stackManipulation = implementationTarget.invokeDominant(invokedMethod.asSignatureToken());
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " as a super method");
                }
                return stackManipulation;
            }
        }

        public static class ForVirtualInvocation
        implements MethodInvoker {
            private final TypeDescription typeDescription;

            protected ForVirtualInvocation(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            protected ForVirtualInvocation(Class<?> type) {
                this(new TypeDescription.ForLoadedType(type));
            }

            @Override
            public StackManipulation invoke(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                if (!invokedMethod.isVirtual()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " virtually");
                }
                if (!invokedMethod.isInvokableOn(this.typeDescription.asErasure())) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + this.typeDescription);
                }
                if (!this.typeDescription.asErasure().isAccessibleTo(implementationTarget.getInstrumentedType())) {
                    throw new IllegalStateException(this.typeDescription + " is not accessible to " + implementationTarget.getInstrumentedType());
                }
                return MethodInvocation.invoke(invokedMethod).virtual(this.typeDescription.asErasure());
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForVirtualInvocation)) {
                    return false;
                }
                ForVirtualInvocation other = (ForVirtualInvocation)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription this$typeDescription = this.typeDescription;
                TypeDescription other$typeDescription = other.typeDescription;
                return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForVirtualInvocation;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription $typeDescription = this.typeDescription;
                result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                return result;
            }

            public static enum WithImplicitType implements MethodInvoker
            {
                INSTANCE;


                @Override
                public StackManipulation invoke(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                    if (!invokedMethod.isVirtual()) {
                        throw new IllegalStateException("Cannot invoke " + invokedMethod + " virtually");
                    }
                    return MethodInvocation.invoke(invokedMethod);
                }
            }
        }

        public static enum ForContextualInvocation implements MethodInvoker
        {
            INSTANCE;


            @Override
            public StackManipulation invoke(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                if (invokedMethod.isVirtual() && !invokedMethod.isInvokableOn(implementationTarget.getInstrumentedType())) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + implementationTarget.getInstrumentedType());
                }
                if (!invokedMethod.isVisibleTo(implementationTarget.getInstrumentedType())) {
                    throw new IllegalStateException(invokedMethod + " is not visible to " + implementationTarget.getInstrumentedType());
                }
                return invokedMethod.isVirtual() ? MethodInvocation.invoke(invokedMethod).virtual(implementationTarget.getInstrumentedType()) : MethodInvocation.invoke(invokedMethod);
            }
        }
    }

    protected static interface ArgumentLoader {
        public StackManipulation resolve(ParameterDescription var1, Assigner var2, Assigner.Typing var3);

        public static class ForJavaConstant
        implements ArgumentLoader,
        Factory {
            private final JavaConstant javaConstant;

            public ForJavaConstant(JavaConstant javaConstant) {
                this.javaConstant = javaConstant;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(this.javaConstant.asStackManipulation(), assigner.assign(this.javaConstant.getType().asGenericType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign Class value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForJavaConstant)) {
                    return false;
                }
                ForJavaConstant other = (ForJavaConstant)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                JavaConstant this$javaConstant = this.javaConstant;
                JavaConstant other$javaConstant = other.javaConstant;
                return !(this$javaConstant == null ? other$javaConstant != null : !this$javaConstant.equals(other$javaConstant));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForJavaConstant;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                JavaConstant $javaConstant = this.javaConstant;
                result = result * 59 + ($javaConstant == null ? 43 : $javaConstant.hashCode());
                return result;
            }
        }

        public static class ForEnumerationValue
        implements ArgumentLoader,
        Factory {
            private final EnumerationDescription enumerationDescription;

            protected ForEnumerationValue(EnumerationDescription enumerationDescription) {
                this.enumerationDescription = enumerationDescription;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(FieldAccess.forEnumeration(this.enumerationDescription), assigner.assign(this.enumerationDescription.getEnumerationType().asGenericType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.enumerationDescription.getEnumerationType() + " value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForEnumerationValue)) {
                    return false;
                }
                ForEnumerationValue other = (ForEnumerationValue)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                EnumerationDescription this$enumerationDescription = this.enumerationDescription;
                EnumerationDescription other$enumerationDescription = other.enumerationDescription;
                return !(this$enumerationDescription == null ? other$enumerationDescription != null : !this$enumerationDescription.equals(other$enumerationDescription));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForEnumerationValue;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                EnumerationDescription $enumerationDescription = this.enumerationDescription;
                result = result * 59 + ($enumerationDescription == null ? 43 : $enumerationDescription.hashCode());
                return result;
            }
        }

        public static class ForClassConstant
        implements ArgumentLoader,
        Factory {
            private final TypeDescription typeDescription;

            protected ForClassConstant(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(ClassConstant.of(this.typeDescription), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Class.class), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign class value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForClassConstant)) {
                    return false;
                }
                ForClassConstant other = (ForClassConstant)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription this$typeDescription = this.typeDescription;
                TypeDescription other$typeDescription = other.typeDescription;
                return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForClassConstant;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription $typeDescription = this.typeDescription;
                result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                return result;
            }
        }

        public static class ForTextConstant
        implements ArgumentLoader,
        Factory {
            private final String value;

            protected ForTextConstant(String value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(new TextConstant(this.value), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(String.class), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign String value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForTextConstant)) {
                    return false;
                }
                ForTextConstant other = (ForTextConstant)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$value = this.value;
                String other$value = other.value;
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForTextConstant;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $value = this.value;
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }

        public static class ForDoubleConstant
        implements ArgumentLoader,
        Factory {
            private final double value;

            protected ForDoubleConstant(double value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(DoubleConstant.forValue(this.value), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Double.TYPE), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign double value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForDoubleConstant)) {
                    return false;
                }
                ForDoubleConstant other = (ForDoubleConstant)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return Double.compare(this.value, other.value) == 0;
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForDoubleConstant;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $value = Double.doubleToLongBits(this.value);
                result = result * 59 + (int)($value >>> 32 ^ $value);
                return result;
            }
        }

        public static class ForFloatConstant
        implements ArgumentLoader,
        Factory {
            private final float value;

            protected ForFloatConstant(float value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(FloatConstant.forValue(this.value), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Float.TYPE), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign float value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForFloatConstant)) {
                    return false;
                }
                ForFloatConstant other = (ForFloatConstant)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return Float.compare(this.value, other.value) == 0;
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForFloatConstant;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + Float.floatToIntBits(this.value);
                return result;
            }
        }

        public static class ForLongConstant
        implements ArgumentLoader,
        Factory {
            private final long value;

            protected ForLongConstant(long value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(LongConstant.forValue(this.value), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Long.TYPE), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign long value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForLongConstant)) {
                    return false;
                }
                ForLongConstant other = (ForLongConstant)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return this.value == other.value;
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForLongConstant;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $value = this.value;
                result = result * 59 + (int)($value >>> 32 ^ $value);
                return result;
            }
        }

        public static class ForIntegerConstant
        implements ArgumentLoader,
        Factory {
            private final int value;

            protected ForIntegerConstant(int value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(IntegerConstant.forValue(this.value), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Integer.TYPE), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign integer value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForIntegerConstant)) {
                    return false;
                }
                ForIntegerConstant other = (ForIntegerConstant)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return this.value == other.value;
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForIntegerConstant;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.value;
                return result;
            }
        }

        public static class ForCharacterConstant
        implements ArgumentLoader,
        Factory {
            private final char value;

            protected ForCharacterConstant(char value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(IntegerConstant.forValue(this.value), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Character.TYPE), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign char value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForCharacterConstant)) {
                    return false;
                }
                ForCharacterConstant other = (ForCharacterConstant)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return this.value == other.value;
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForCharacterConstant;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.value;
                return result;
            }
        }

        public static class ForShortConstant
        implements ArgumentLoader,
        Factory {
            private final short value;

            protected ForShortConstant(short value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(IntegerConstant.forValue(this.value), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Short.TYPE), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign short value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForShortConstant)) {
                    return false;
                }
                ForShortConstant other = (ForShortConstant)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return this.value == other.value;
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForShortConstant;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.value;
                return result;
            }
        }

        public static class ForByteConstant
        implements ArgumentLoader,
        Factory {
            private final byte value;

            protected ForByteConstant(byte value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(IntegerConstant.forValue(this.value), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Byte.TYPE), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign byte value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForByteConstant)) {
                    return false;
                }
                ForByteConstant other = (ForByteConstant)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return this.value == other.value;
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForByteConstant;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.value;
                return result;
            }
        }

        public static class ForBooleanConstant
        implements ArgumentLoader,
        Factory {
            private final boolean value;

            protected ForBooleanConstant(boolean value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(IntegerConstant.forValue(this.value), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Boolean.TYPE), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign boolean value to " + target);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForBooleanConstant)) {
                    return false;
                }
                ForBooleanConstant other = (ForBooleanConstant)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return this.value == other.value;
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForBooleanConstant;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.value ? 79 : 97);
                return result;
            }
        }

        public static class ForMethodParameterArray
        implements ArgumentLoader {
            private final ParameterDescription parameterDescription;
            private final int index;

            protected ForMethodParameterArray(ParameterDescription parameterDescription, int index) {
                this.parameterDescription = parameterDescription;
                this.index = index;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.load(this.parameterDescription), IntegerConstant.forValue(this.index), ArrayAccess.of(this.parameterDescription.getType().getComponentType()).load(), assigner.assign(this.parameterDescription.getType().getComponentType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.parameterDescription.getType().getComponentType() + " to " + target);
                }
                return stackManipulation;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForMethodParameterArray)) {
                    return false;
                }
                ForMethodParameterArray other = (ForMethodParameterArray)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ParameterDescription this$parameterDescription = this.parameterDescription;
                ParameterDescription other$parameterDescription = other.parameterDescription;
                if (this$parameterDescription == null ? other$parameterDescription != null : !this$parameterDescription.equals(other$parameterDescription)) {
                    return false;
                }
                return this.index == other.index;
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForMethodParameterArray;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ParameterDescription $parameterDescription = this.parameterDescription;
                result = result * 59 + ($parameterDescription == null ? 43 : $parameterDescription.hashCode());
                result = result * 59 + this.index;
                return result;
            }

            protected static class OfInvokedMethod
            implements Factory {
                private final int index;

                protected OfInvokedMethod(int index) {
                    this.index = index;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    if (instrumentedMethod.getParameters().size() <= this.index) {
                        throw new IllegalStateException(instrumentedMethod + " does not declare a parameter with index " + this.index);
                    }
                    if (!((ParameterDescription)instrumentedMethod.getParameters().get(this.index)).getType().isArray()) {
                        throw new IllegalStateException("Cannot access an item from non-array parameter " + instrumentedMethod.getParameters().get(this.index));
                    }
                    ArrayList<ArgumentLoader> argumentLoaders = new ArrayList<ArgumentLoader>(instrumentedMethod.getParameters().size());
                    for (int index = 0; index < invokedMethod.getParameters().size(); ++index) {
                        argumentLoaders.add(new ForMethodParameterArray((ParameterDescription)instrumentedMethod.getParameters().get(this.index), index++));
                    }
                    return argumentLoaders;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof OfInvokedMethod)) {
                        return false;
                    }
                    OfInvokedMethod other = (OfInvokedMethod)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    return this.index == other.index;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof OfInvokedMethod;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.index;
                    return result;
                }
            }

            protected static class OfParameter
            implements Factory {
                private final int index;
                private final int arrayIndex;

                protected OfParameter(int index, int arrayIndex) {
                    this.index = index;
                    this.arrayIndex = arrayIndex;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    if (instrumentedMethod.getParameters().size() <= this.index) {
                        throw new IllegalStateException(instrumentedMethod + " does not declare a parameter with index " + this.index);
                    }
                    if (!((ParameterDescription)instrumentedMethod.getParameters().get(this.index)).getType().isArray()) {
                        throw new IllegalStateException("Cannot access an item from non-array parameter " + instrumentedMethod.getParameters().get(this.index));
                    }
                    return Collections.singletonList(new ForMethodParameterArray((ParameterDescription)instrumentedMethod.getParameters().get(this.index), this.arrayIndex));
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof OfParameter)) {
                        return false;
                    }
                    OfParameter other = (OfParameter)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (this.index != other.index) {
                        return false;
                    }
                    return this.arrayIndex == other.arrayIndex;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof OfParameter;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.index;
                    result = result * 59 + this.arrayIndex;
                    return result;
                }
            }
        }

        public static class ForField
        implements ArgumentLoader {
            private final FieldDescription fieldDescription;
            private final MethodDescription instrumentedMethod;

            protected ForField(FieldDescription fieldDescription, MethodDescription instrumentedMethod) {
                this.fieldDescription = fieldDescription;
                this.instrumentedMethod = instrumentedMethod;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                if (!this.fieldDescription.isStatic() && this.instrumentedMethod.isStatic()) {
                    throw new IllegalStateException("Cannot access non-static " + this.fieldDescription + " from " + this.instrumentedMethod);
                }
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), FieldAccess.forField(this.fieldDescription).read(), assigner.assign(this.fieldDescription.getType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.fieldDescription + " to " + target);
                }
                return stackManipulation;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForField)) {
                    return false;
                }
                ForField other = (ForField)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                FieldDescription this$fieldDescription = this.fieldDescription;
                FieldDescription other$fieldDescription = other.fieldDescription;
                if (this$fieldDescription == null ? other$fieldDescription != null : !this$fieldDescription.equals(other$fieldDescription)) {
                    return false;
                }
                MethodDescription this$instrumentedMethod = this.instrumentedMethod;
                MethodDescription other$instrumentedMethod = other.instrumentedMethod;
                return !(this$instrumentedMethod == null ? other$instrumentedMethod != null : !this$instrumentedMethod.equals(other$instrumentedMethod));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForField;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                FieldDescription $fieldDescription = this.fieldDescription;
                result = result * 59 + ($fieldDescription == null ? 43 : $fieldDescription.hashCode());
                MethodDescription $instrumentedMethod = this.instrumentedMethod;
                result = result * 59 + ($instrumentedMethod == null ? 43 : $instrumentedMethod.hashCode());
                return result;
            }

            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory {
                private final String name;
                private final FieldLocator.Factory fieldLocatorFactory;

                protected Factory(String name, FieldLocator.Factory fieldLocatorFactory) {
                    this.name = name;
                    this.fieldLocatorFactory = fieldLocatorFactory;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    FieldLocator.Resolution resolution = this.fieldLocatorFactory.make(instrumentedType).locate(this.name);
                    if (!resolution.isResolved()) {
                        throw new IllegalStateException("Could not locate field '" + this.name + "' on " + instrumentedType);
                    }
                    return Collections.singletonList(new ForField(resolution.getField(), instrumentedMethod));
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Factory)) {
                        return false;
                    }
                    Factory other = (Factory)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$name = this.name;
                    String other$name = other.name;
                    if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                        return false;
                    }
                    FieldLocator.Factory this$fieldLocatorFactory = this.fieldLocatorFactory;
                    FieldLocator.Factory other$fieldLocatorFactory = other.fieldLocatorFactory;
                    return !(this$fieldLocatorFactory == null ? other$fieldLocatorFactory != null : !this$fieldLocatorFactory.equals(other$fieldLocatorFactory));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Factory;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $name = this.name;
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    FieldLocator.Factory $fieldLocatorFactory = this.fieldLocatorFactory;
                    result = result * 59 + ($fieldLocatorFactory == null ? 43 : $fieldLocatorFactory.hashCode());
                    return result;
                }
            }
        }

        public static class ForInstance
        implements ArgumentLoader {
            private final FieldDescription fieldDescription;

            protected ForInstance(FieldDescription fieldDescription) {
                this.fieldDescription = fieldDescription;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(FieldAccess.forField(this.fieldDescription).read(), assigner.assign(this.fieldDescription.getType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.fieldDescription.getType() + " to " + target);
                }
                return stackManipulation;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForInstance)) {
                    return false;
                }
                ForInstance other = (ForInstance)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                FieldDescription this$fieldDescription = this.fieldDescription;
                FieldDescription other$fieldDescription = other.fieldDescription;
                return !(this$fieldDescription == null ? other$fieldDescription != null : !this$fieldDescription.equals(other$fieldDescription));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForInstance;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                FieldDescription $fieldDescription = this.fieldDescription;
                result = result * 59 + ($fieldDescription == null ? 43 : $fieldDescription.hashCode());
                return result;
            }

            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory {
                private static final String FIELD_PREFIX = "methodCall";
                private final Object value;
                private final String name;

                protected Factory(Object value) {
                    this.value = value;
                    this.name = String.format("%s$%s", FIELD_PREFIX, RandomString.make());
                }

                protected static net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory of(Object value) {
                    if (value == null) {
                        return ForNullConstant.INSTANCE;
                    }
                    if (value instanceof String) {
                        return new ForTextConstant((String)value);
                    }
                    if (value instanceof Boolean) {
                        return new ForBooleanConstant((Boolean)value);
                    }
                    if (value instanceof Byte) {
                        return new ForByteConstant((Byte)value);
                    }
                    if (value instanceof Short) {
                        return new ForShortConstant((Short)value);
                    }
                    if (value instanceof Character) {
                        return new ForCharacterConstant(((Character)value).charValue());
                    }
                    if (value instanceof Integer) {
                        return new ForIntegerConstant((Integer)value);
                    }
                    if (value instanceof Long) {
                        return new ForLongConstant((Long)value);
                    }
                    if (value instanceof Float) {
                        return new ForFloatConstant(((Float)value).floatValue());
                    }
                    if (value instanceof Double) {
                        return new ForDoubleConstant((Double)value);
                    }
                    if (value instanceof Class) {
                        return new ForClassConstant(new TypeDescription.ForLoadedType((Class)value));
                    }
                    if (JavaType.METHOD_HANDLE.getTypeStub().isInstance(value)) {
                        return new ForJavaConstant(JavaConstant.MethodHandle.ofLoaded(value));
                    }
                    if (JavaType.METHOD_TYPE.getTypeStub().isInstance(value)) {
                        return new ForJavaConstant(JavaConstant.MethodType.ofLoaded(value));
                    }
                    if (value instanceof Enum) {
                        return new ForEnumerationValue(new EnumerationDescription.ForLoadedEnumeration((Enum)value));
                    }
                    return new Factory(value);
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType.withField(new FieldDescription.Token(this.name, 4105, new TypeDescription.Generic.OfNonGenericType.ForLoadedType(this.value.getClass()))).withInitializer(new LoadedTypeInitializer.ForStaticField(this.name, this.value));
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    return Collections.singletonList(new ForInstance((FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.name))).getOnly()));
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Factory)) {
                        return false;
                    }
                    Factory other = (Factory)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Object this$value = this.value;
                    Object other$value = other.value;
                    return !(this$value == null ? other$value != null : !this$value.equals(other$value));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Factory;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Object $value = this.value;
                    result = result * 59 + ($value == null ? 43 : $value.hashCode());
                    return result;
                }
            }
        }

        public static class ForMethodParameter
        implements ArgumentLoader {
            private final int index;
            private final MethodDescription instrumentedMethod;

            protected ForMethodParameter(int index, MethodDescription instrumentedMethod) {
                this.index = index;
                this.instrumentedMethod = instrumentedMethod;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                ParameterDescription parameterDescription = (ParameterDescription)this.instrumentedMethod.getParameters().get(this.index);
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.load(parameterDescription), assigner.assign(parameterDescription.getType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + parameterDescription + " to " + target + " for " + this.instrumentedMethod);
                }
                return stackManipulation;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForMethodParameter)) {
                    return false;
                }
                ForMethodParameter other = (ForMethodParameter)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.index != other.index) {
                    return false;
                }
                MethodDescription this$instrumentedMethod = this.instrumentedMethod;
                MethodDescription other$instrumentedMethod = other.instrumentedMethod;
                return !(this$instrumentedMethod == null ? other$instrumentedMethod != null : !this$instrumentedMethod.equals(other$instrumentedMethod));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForMethodParameter;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.index;
                MethodDescription $instrumentedMethod = this.instrumentedMethod;
                result = result * 59 + ($instrumentedMethod == null ? 43 : $instrumentedMethod.hashCode());
                return result;
            }

            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory {
                private final int index;

                protected Factory(int index) {
                    this.index = index;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    if (this.index >= instrumentedMethod.getParameters().size()) {
                        throw new IllegalStateException(instrumentedMethod + " does not have a parameter with index " + this.index);
                    }
                    return Collections.singletonList(new ForMethodParameter(this.index, instrumentedMethod));
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Factory)) {
                        return false;
                    }
                    Factory other = (Factory)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    return this.index == other.index;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Factory;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.index;
                    return result;
                }
            }

            protected static enum OfInstrumentedMethod implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory
            {
                INSTANCE;


                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    ArrayList<ArgumentLoader> argumentLoaders = new ArrayList<ArgumentLoader>(instrumentedMethod.getParameters().size());
                    for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                        argumentLoaders.add(new ForMethodParameter(parameterDescription.getIndex(), instrumentedMethod));
                    }
                    return argumentLoaders;
                }
            }
        }

        public static class ForInstrumentedType
        implements ArgumentLoader {
            private final TypeDescription instrumentedType;

            protected ForInstrumentedType(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(ClassConstant.of(this.instrumentedType), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Class.class), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign Class value to " + target);
                }
                return stackManipulation;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForInstrumentedType)) {
                    return false;
                }
                ForInstrumentedType other = (ForInstrumentedType)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription this$instrumentedType = this.instrumentedType;
                TypeDescription other$instrumentedType = other.instrumentedType;
                return !(this$instrumentedType == null ? other$instrumentedType != null : !this$instrumentedType.equals(other$instrumentedType));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForInstrumentedType;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription $instrumentedType = this.instrumentedType;
                result = result * 59 + ($instrumentedType == null ? 43 : $instrumentedType.hashCode());
                return result;
            }

            protected static enum Factory implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory
            {
                INSTANCE;


                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    return Collections.singletonList(new ForInstrumentedType(instrumentedType));
                }
            }
        }

        public static class ForThisReference
        implements ArgumentLoader {
            private final TypeDescription instrumentedType;

            protected ForThisReference(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.loadThis(), assigner.assign(this.instrumentedType.asGenericType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.instrumentedType + " to " + target);
                }
                return stackManipulation;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForThisReference)) {
                    return false;
                }
                ForThisReference other = (ForThisReference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription this$instrumentedType = this.instrumentedType;
                TypeDescription other$instrumentedType = other.instrumentedType;
                return !(this$instrumentedType == null ? other$instrumentedType != null : !this$instrumentedType.equals(other$instrumentedType));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForThisReference;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription $instrumentedType = this.instrumentedType;
                result = result * 59 + ($instrumentedType == null ? 43 : $instrumentedType.hashCode());
                return result;
            }

            protected static enum Factory implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory
            {
                INSTANCE;


                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    if (instrumentedMethod.isStatic()) {
                        throw new IllegalStateException(instrumentedMethod + " is static and cannot supply an invoker instance");
                    }
                    return Collections.singletonList(new ForThisReference(instrumentedType));
                }
            }
        }

        public static enum ForNullConstant implements ArgumentLoader,
        Factory
        {
            INSTANCE;


            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                if (target.getType().isPrimitive()) {
                    throw new IllegalStateException("Cannot assign null to " + target);
                }
                return NullConstant.INSTANCE;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }
        }

        public static interface Factory {
            public InstrumentedType prepare(InstrumentedType var1);

            public List<ArgumentLoader> make(TypeDescription var1, MethodDescription var2, MethodDescription var3);
        }
    }

    protected static interface TargetHandler
    extends InstrumentedType.Prepareable {
        public StackManipulation resolve(MethodDescription var1, MethodDescription var2, TypeDescription var3, Assigner var4, Assigner.Typing var5);

        public static class ForMethodParameter
        implements TargetHandler {
            private final int index;

            protected ForMethodParameter(int index) {
                this.index = index;
            }

            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                if (instrumentedMethod.getParameters().size() < this.index) {
                    throw new IllegalArgumentException(instrumentedMethod + " does not have a parameter with index " + this.index);
                }
                ParameterDescription parameterDescription = (ParameterDescription)instrumentedMethod.getParameters().get(this.index);
                StackManipulation stackManipulation = assigner.assign(parameterDescription.getType(), invokedMethod.getDeclaringType().asGenericType(), typing);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + parameterDescription.getType());
                }
                return new StackManipulation.Compound(MethodVariableAccess.load(parameterDescription), stackManipulation);
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForMethodParameter)) {
                    return false;
                }
                ForMethodParameter other = (ForMethodParameter)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return this.index == other.index;
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForMethodParameter;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.index;
                return result;
            }
        }

        public static class ForField
        implements TargetHandler {
            private final String name;
            private final FieldLocator.Factory fieldLocatorFactory;

            protected ForField(String name, FieldLocator.Factory fieldLocatorFactory) {
                this.name = name;
                this.fieldLocatorFactory = fieldLocatorFactory;
            }

            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                FieldLocator.Resolution resolution = this.fieldLocatorFactory.make(instrumentedType).locate(this.name);
                if (!resolution.isResolved()) {
                    throw new IllegalStateException("Could not locate field name " + this.name + " on " + instrumentedType);
                }
                if (!resolution.getField().isStatic() && !instrumentedType.isAssignableTo(resolution.getField().getDeclaringType().asErasure())) {
                    throw new IllegalStateException("Cannot access " + resolution.getField() + " from " + instrumentedType);
                }
                StackManipulation stackManipulation = assigner.assign(resolution.getField().getType(), invokedMethod.getDeclaringType().asGenericType(), typing);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + resolution.getField());
                }
                return new StackManipulation.Compound(invokedMethod.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), FieldAccess.forField(resolution.getField()).read(), stackManipulation);
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForField)) {
                    return false;
                }
                ForField other = (ForField)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.name;
                String other$name = other.name;
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                FieldLocator.Factory this$fieldLocatorFactory = this.fieldLocatorFactory;
                FieldLocator.Factory other$fieldLocatorFactory = other.fieldLocatorFactory;
                return !(this$fieldLocatorFactory == null ? other$fieldLocatorFactory != null : !this$fieldLocatorFactory.equals(other$fieldLocatorFactory));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForField;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.name;
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                FieldLocator.Factory $fieldLocatorFactory = this.fieldLocatorFactory;
                result = result * 59 + ($fieldLocatorFactory == null ? 43 : $fieldLocatorFactory.hashCode());
                return result;
            }
        }

        public static class ForValue
        implements TargetHandler {
            private static final String FIELD_PREFIX = "invocationTarget";
            private final Object target;
            private final TypeDescription.Generic fieldType;
            private final String name;

            protected ForValue(Object target, TypeDescription.Generic fieldType) {
                this.target = target;
                this.fieldType = fieldType;
                this.name = String.format("%s$%s", FIELD_PREFIX, RandomString.make());
            }

            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                StackManipulation stackManipulation = assigner.assign(this.fieldType, invokedMethod.getDeclaringType().asGenericType(), typing);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + this.fieldType);
                }
                return new StackManipulation.Compound(FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.name))).getOnly()).read(), stackManipulation);
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withField(new FieldDescription.Token(this.name, 4105, this.fieldType)).withInitializer(new LoadedTypeInitializer.ForStaticField(this.name, this.target));
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForValue)) {
                    return false;
                }
                ForValue other = (ForValue)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Object this$target = this.target;
                Object other$target = other.target;
                if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                    return false;
                }
                TypeDescription.Generic this$fieldType = this.fieldType;
                TypeDescription.Generic other$fieldType = other.fieldType;
                return !(this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForValue;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Object $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                TypeDescription.Generic $fieldType = this.fieldType;
                result = result * 59 + ($fieldType == null ? 43 : $fieldType.hashCode());
                return result;
            }
        }

        public static enum ForConstructingInvocation implements TargetHandler
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                return new StackManipulation.Compound(TypeCreation.of(invokedMethod.getDeclaringType().asErasure()), Duplication.SINGLE);
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }
        }

        public static enum ForSelfOrStaticInvocation implements TargetHandler
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                return new StackManipulation.Compound(invokedMethod.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), (StackManipulation)((Object)(invokedMethod.isConstructor() ? Duplication.SINGLE : StackManipulation.Trivial.INSTANCE)));
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }
        }
    }

    public static interface MethodLocator {
        public MethodDescription resolve(TypeDescription var1, MethodDescription var2);

        public static class ForElementMatcher
        implements MethodLocator {
            private final ElementMatcher<? super MethodDescription> matcher;
            private final MethodGraph.Compiler methodGraphCompiler;

            protected ForElementMatcher(ElementMatcher<? super MethodDescription> matcher, MethodGraph.Compiler methodGraphCompiler) {
                this.matcher = matcher;
                this.methodGraphCompiler = methodGraphCompiler;
            }

            @Override
            public MethodDescription resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                MethodList candidates = (MethodList)this.methodGraphCompiler.compile(instrumentedType).listNodes().asMethodList().filter(this.matcher);
                if (candidates.size() == 1) {
                    return (MethodDescription)candidates.getOnly();
                }
                throw new IllegalStateException(instrumentedType + " does not define exactly one virtual method for " + this.matcher);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForElementMatcher)) {
                    return false;
                }
                ForElementMatcher other = (ForElementMatcher)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ElementMatcher<? super MethodDescription> this$matcher = this.matcher;
                ElementMatcher<? super MethodDescription> other$matcher = other.matcher;
                if (this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher)) {
                    return false;
                }
                MethodGraph.Compiler this$methodGraphCompiler = this.methodGraphCompiler;
                MethodGraph.Compiler other$methodGraphCompiler = other.methodGraphCompiler;
                return !(this$methodGraphCompiler == null ? other$methodGraphCompiler != null : !this$methodGraphCompiler.equals(other$methodGraphCompiler));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForElementMatcher;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ElementMatcher<? super MethodDescription> $matcher = this.matcher;
                result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
                MethodGraph.Compiler $methodGraphCompiler = this.methodGraphCompiler;
                result = result * 59 + ($methodGraphCompiler == null ? 43 : $methodGraphCompiler.hashCode());
                return result;
            }
        }

        public static class ForExplicitMethod
        implements MethodLocator {
            private final MethodDescription methodDescription;

            protected ForExplicitMethod(MethodDescription methodDescription) {
                this.methodDescription = methodDescription;
            }

            @Override
            public MethodDescription resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return this.methodDescription;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForExplicitMethod)) {
                    return false;
                }
                ForExplicitMethod other = (ForExplicitMethod)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                MethodDescription this$methodDescription = this.methodDescription;
                MethodDescription other$methodDescription = other.methodDescription;
                return !(this$methodDescription == null ? other$methodDescription != null : !this$methodDescription.equals(other$methodDescription));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForExplicitMethod;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                MethodDescription $methodDescription = this.methodDescription;
                result = result * 59 + ($methodDescription == null ? 43 : $methodDescription.hashCode());
                return result;
            }
        }

        public static enum ForInstrumentedMethod implements MethodLocator
        {
            INSTANCE;


            @Override
            public MethodDescription resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return instrumentedMethod;
            }
        }
    }
}

