/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.intelie.live.BayeuxChannel;
import net.intelie.live.Query;
import net.intelie.live.QueryAtom;
import net.intelie.live.QueryListener;

public class BayeuxQuery {
    private String remoteHost;
    private boolean bypassSecurity;
    private List<QueryAtom> queries;
    private Function<BayeuxChannel, QueryListener> listenerFactory;

    public BayeuxQuery(String remoteHost) {
        this.remoteHost = remoteHost;
        this.bypassSecurity = false;
        this.queries = new ArrayList<QueryAtom>();
    }

    public BayeuxQuery bypassSecurity() {
        return this.bypassSecurity(true);
    }

    public BayeuxQuery bypassSecurity(boolean bypassSecurity) {
        this.bypassSecurity = bypassSecurity;
        return this;
    }

    public BayeuxQuery addQuery(Query query, String url) {
        return this.addQuery(new QueryAtom(query, url));
    }

    public BayeuxQuery addQuery(QueryAtom atom) {
        this.queries.add(atom);
        return this;
    }

    public BayeuxQuery listenerFactory(Function<BayeuxChannel, QueryListener> listenerFactory) {
        this.listenerFactory = listenerFactory;
        return this;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public boolean getBypassSecurity() {
        return this.bypassSecurity;
    }

    public List<QueryAtom> getQueries() {
        return this.queries;
    }

    public Function<BayeuxChannel, QueryListener> getListenerFactory() {
        return this.listenerFactory;
    }
}

