/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.util.Map;
import net.intelie.live.BayeuxChannel;
import net.intelie.live.ControlEvent;
import net.intelie.live.DestroyInfo;
import net.intelie.live.LiveJson;
import net.intelie.live.QueryEvent;
import net.intelie.live.QueryListener;
import net.intelie.live.StopInfo;
import net.intelie.live.StopReason;

public class BayeuxQueryListener
extends QueryListener.Empty {
    private static final Gson gson = LiveJson.create();
    private final BayeuxChannel channel;

    public BayeuxQueryListener(BayeuxChannel channel) {
        this.channel = channel;
    }

    @Override
    public void onCustom(ControlEvent event) {
        this.publishJson(event);
    }

    @Override
    public void onStop(StopInfo event) throws Exception {
        StopReason reason = event.reason();
        this.publishJson(ImmutableMap.of((Object)"type", (Object)"stop", (Object)"message", (Object)reason.message(), (Object)"reason", (Object)reason.getClass().getSimpleName(), (Object)"user", (Object)reason.userAction()));
    }

    @Override
    public void onDestroy(DestroyInfo event) throws Exception {
        super.onDestroy(event);
        this.channel.close();
    }

    @Override
    public void onEvent(QueryEvent event, boolean history) {
        this.publishJson(ImmutableMap.of((Object)"type", (Object)"event", (Object)"content", (Object)event, (Object)"history", (Object)history));
    }

    private void publishJson(Object obj) {
        this.channel.send(gson.fromJson(gson.toJson(obj), Map.class));
    }
}

