/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import net.intelie.live.Event;
import net.intelie.live.EventIterator;
import net.intelie.live.util.AutoList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcatEventIterator
implements EventIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcatEventIterator.class);
    private final Queue<EventIterator> next;
    private int count;
    @Nullable
    private EventIterator current;

    public ConcatEventIterator(EventIterator ... iterators) {
        this(Arrays.asList(iterators));
    }

    public ConcatEventIterator(List<EventIterator> iterators) {
        try (AutoList<EventIterator> list = new AutoList<EventIterator>(iterators);){
            this.next = new ArrayDeque<EventIterator>(list.get());
            this.count = this.next.stream().mapToInt(EventIterator::count).sum();
            this.current = this.next.poll();
            list.release();
        }
    }

    private static void close(@NotNull EventIterator current) {
        try {
            current.close();
        }
        catch (Throwable t) {
            LOGGER.error("Error closing event iterator", t);
        }
    }

    @Override
    public boolean moveNext() {
        while (this.current != null) {
            int beforeCount = this.current.count();
            if (this.current.moveNext()) {
                this.count += this.current.count() - beforeCount;
                break;
            }
            ConcatEventIterator.close(this.current);
            this.current = this.next.poll();
        }
        return this.current != null;
    }

    public EventIterator currentIterator() {
        return this.current;
    }

    @Override
    public Event current() {
        return this.current != null ? this.current.current() : null;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public long estimateBytes() {
        return this.current != null ? this.current.estimateBytes() : 0L;
    }

    @Override
    public boolean delete() {
        return this.current != null && this.current.delete();
    }

    @Override
    public void close() {
        do {
            if (this.current == null) continue;
            ConcatEventIterator.close(this.current);
        } while ((this.current = this.next.poll()) != null);
    }

    @Override
    public boolean cacheRead() {
        return this.current != null && this.current.cacheRead();
    }

    @Override
    public boolean cacheWrite() {
        return this.current != null && this.current.cacheWrite();
    }
}

