/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class ControlEvent {
    private final String type;
    private final Map<String, Object> info;

    public ControlEvent(String type, Map<String, Object> info) {
        this.type = type;
        this.info = info != null ? Collections.unmodifiableMap(info) : null;
    }

    public String type() {
        return this.type;
    }

    public Map<String, Object> info() {
        return this.info;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Objects.equals(o.getClass(), this.getClass())) {
            return false;
        }
        ControlEvent that = (ControlEvent)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.info, that.info);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.info);
    }

    public String makeStringFor(Object ... objs) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("'type':'").append(this.type).append("'");
        if (this.info != null) {
            builder.append(", 'info':'").append(this.info).append("'");
        }
        int i = 0;
        while (i + 1 < objs.length) {
            if (objs[i + 1] != null) {
                builder.append(", '").append(objs[i]).append("':'").append(objs[i + 1]).append("'");
            }
            i += 2;
        }
        return builder.append("}").toString();
    }

    public String toString() {
        return this.makeStringFor(new Object[0]);
    }
}

