/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Collection;
import net.intelie.live.Alias;
import net.intelie.live.CriteriaSpecification;
import net.intelie.live.EntityList;
import net.intelie.live.InnerSpecification;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class CriteriaSpecificationBase<T>
implements CriteriaSpecification<T> {
    protected final InnerSpecification<T> spec;

    public CriteriaSpecificationBase(Class<T> type) {
        this(new InnerSpecification<T>(type));
    }

    public CriteriaSpecificationBase(InnerSpecification<T> spec) {
        this.spec = spec;
    }

    @Override
    public CriteriaSpecificationBase<T> orderBy(String ... properties) {
        return new CriteriaSpecificationBase<T>(this.spec.orderBy(properties));
    }

    @Override
    public CriteriaSpecificationBase<T> orderByDescending(String ... properties) {
        return new CriteriaSpecificationBase<T>(this.spec.orderByDescending(properties));
    }

    @Override
    public CriteriaSpecificationBase<T> page(Integer page) {
        return new CriteriaSpecificationBase<T>(this.spec.page(page));
    }

    @Override
    public CriteriaSpecificationBase<T> pageSize(Integer pageSize) {
        return new CriteriaSpecificationBase<T>(this.spec.pageSize(pageSize));
    }

    @Override
    public CriteriaSpecification<T> diffOnly(boolean diffOnly) {
        return new CriteriaSpecificationBase<T>(this.spec.diffOnly(diffOnly));
    }

    @Override
    public CriteriaSpecificationBase<T> at(Integer page, String sortProperty, Integer sortDirection) {
        return super.paginateIfNeeded(page);
    }

    @Override
    public CriteriaSpecification<T> at(Integer page, String sortProperty, Integer sortDirection, boolean diffOnly) {
        return super.paginateIfNeeded(page).diffOnly(diffOnly);
    }

    @Override
    public CriteriaSpecification<T> where(Criterion criterion) {
        return new CriteriaSpecificationBase<T>(this.spec.where(criterion));
    }

    @Override
    public CriteriaSpecification<T> createAlias(Alias alias) {
        return new CriteriaSpecificationBase<T>(this.spec.createAlias(alias));
    }

    @Override
    public CriteriaSpecification<T> fetch(String property) {
        return new CriteriaSpecificationBase<T>(this.spec.fetch(property));
    }

    @Override
    public CriteriaSpecification<T> byId(Serializable id) {
        return this.where((Criterion)Restrictions.eq((String)"id", (Object)id));
    }

    @Override
    public CriteriaSpecification<T> byIds(Collection<? extends Serializable> ids) {
        if (ids == null || ids.isEmpty()) {
            return this.where(Restrictions.sqlRestriction((String)"(1 = 0)"));
        }
        return this.where(Restrictions.in((String)"id", ids));
    }

    @Override
    public CriteriaSpecification<T> byIdsNotIn(Collection<? extends Serializable> ids) {
        if (ids == null || ids.isEmpty()) {
            return this;
        }
        return this.where(Restrictions.not((Criterion)Restrictions.in((String)"id", ids)));
    }

    private CriteriaSpecificationBase<T> paginateIfNeeded(Integer page) {
        if (page != null) {
            return this.page(page);
        }
        return this;
    }

    private CriteriaSpecificationBase<T> sortIfNeeded(String sortProperty, Integer sortDirection) {
        if (sortProperty != null) {
            if (sortDirection != null && sortDirection.compareTo(0) < 0) {
                return this.orderByDescending(new String[]{sortProperty});
            }
            return this.orderBy(new String[]{sortProperty});
        }
        return this;
    }

    @Override
    public Class<T> type() {
        return this.spec.type();
    }

    @Override
    public InnerSpecification<T> data() {
        return this.spec;
    }

    @Override
    public EntityList<T> all(Session session) {
        return this.spec.all(session);
    }

    @Override
    public T one(Session session) {
        return this.spec.one(session);
    }

    @Override
    public long count(Session session) {
        return this.spec.count(session);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CriteriaSpecificationBase)) {
            return false;
        }
        CriteriaSpecificationBase that = (CriteriaSpecificationBase)o;
        return Objects.equal(this.spec, that.spec);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.spec});
    }

    public String toString() {
        return this.spec.toString();
    }
}

