/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class ElementInfo {
    public static final ElementInfo UNKNOWN = new ElementInfo("unknown", "unknown", null, null);
    private final String type;
    private final String description;
    private final String details;
    private final String url;
    private final Map<String, Object> additional;

    public ElementInfo(String type, String description, String details, String url) {
        this(type, description, details, url, Collections.emptyMap());
    }

    public ElementInfo(String type, String description, String details, String url, Map<String, Object> additional) {
        this.type = ElementInfo.safe(type);
        this.description = ElementInfo.safe(description);
        this.details = ElementInfo.safe(details);
        this.additional = additional;
        this.url = url;
    }

    private static String safe(String s) {
        if (s == null) {
            return null;
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (String l : s.split("\n")) {
            if (l == null || l.isEmpty()) continue;
            lines.add(l.trim());
        }
        String line = Joiner.on((String)" ").join(lines);
        if (line.length() > 80) {
            line = line.substring(0, 77) + "...";
        }
        return line;
    }

    public String type() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public String details() {
        return this.details;
    }

    public String url() {
        return this.url;
    }

    public Map<String, Object> additional() {
        return this.additional;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ElementInfo)) {
            return false;
        }
        ElementInfo that = (ElementInfo)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.description, that.description) && Objects.equals(this.details, that.details) && Objects.equals(this.url, that.url) && Objects.equals(this.additional, that.additional);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.description, this.details, this.url, this.additional);
    }

    public String toString() {
        return this.type + "\n" + this.description + "\n" + this.details + "\n" + this.url + (this.additional.size() > 0 ? "\n" + this.additional : "");
    }
}

