/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.util.Map;
import java.util.Objects;
import net.intelie.live.ElementInfo;
import net.intelie.live.ElementState;

public class ElementSnapshot
extends ElementState
implements Comparable<ElementSnapshot> {
    public static final ElementSnapshot UNKNOWN = new ElementSnapshot(ElementInfo.UNKNOWN, ElementState.UNKNOWN, 0L);
    public static final ElementSnapshot UNSUPPORTED = new ElementSnapshot(ElementInfo.UNKNOWN, ElementState.UNSUPPORTED, 0L);
    private final String type;
    private final String details;
    private final String description;
    private final String url;
    private final Map<String, Object> additional;
    private final long startedAt;

    public ElementSnapshot(ElementInfo description, ElementState state, long startedAt) {
        super(state);
        this.type = description.type();
        this.description = description.description();
        this.details = description.details();
        this.url = description.url();
        this.additional = description.additional();
        this.startedAt = startedAt;
    }

    public String type() {
        return this.type;
    }

    public String details() {
        return this.details;
    }

    public String description() {
        return this.description;
    }

    public String url() {
        return this.url;
    }

    public long startedAt() {
        return this.startedAt;
    }

    public Map<String, Object> additional() {
        return this.additional;
    }

    public ElementState statusOnly() {
        return new ElementState(this);
    }

    public ElementInfo infoOnly() {
        return new ElementInfo(this.type, this.description, this.details, this.url, this.additional);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ElementSnapshot)) {
            return false;
        }
        ElementSnapshot that = (ElementSnapshot)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.description, that.description) && Objects.equals(this.details, that.details) && Objects.equals(this.url, that.url) && Objects.equals(this.additional, that.additional) && Objects.equals(this.startedAt, that.startedAt) && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.description, this.details, this.url, this.additional, this.startedAt, super.hashCode());
    }

    @Override
    public String toString() {
        return "[" + this.type + "] " + this.description + ": " + (Object)((Object)super.status());
    }

    @Override
    public int compareTo(ElementSnapshot o) {
        if (o == null) {
            return 1;
        }
        int i = this.type.compareTo(o.type);
        if (i != 0) {
            return i;
        }
        return Long.compare(this.startedAt, o.startedAt);
    }
}

