/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.intelie.live.ElementStatus;

public class ElementState {
    public static final ElementState OK = new ElementState(ElementStatus.VALID, new String[0]);
    public static final ElementState UNKNOWN = new ElementState(ElementStatus.INVALID, "The element is unknown to the engine.");
    public static final ElementState UNSUPPORTED = new ElementState(ElementStatus.INVALID, "No service in this engine can handle this type of element.");
    public static final ElementState INACTIVE = new ElementState(ElementStatus.INACTIVE, "The selected element is inactive.");
    public static final ElementState STARTING = new ElementState(ElementStatus.INVALID, "The selected element is still starting.");
    public static final ElementState TIMEOUT = new ElementState(ElementStatus.INVALID, "The selected element didn't start in time.");
    private final ElementStatus status;
    private final List<String> messages;
    private final Map<String, Object> metrics;
    private final boolean valid;

    public ElementState(ElementState state) {
        this(state.status, state.messages, state.metrics);
    }

    public ElementState(ElementStatus status, Map<String, Object> metrics) {
        this(status, Collections.emptyList(), metrics);
    }

    public ElementState(ElementStatus status, String ... messages) {
        this(status, Arrays.asList(messages));
    }

    public ElementState(ElementStatus status, Iterable<String> messages) {
        this(status, messages, null);
    }

    public ElementState(ElementStatus status, Iterable<String> messages, Map<String, Object> metrics) {
        this.status = status;
        this.valid = status.valid();
        this.messages = new ArrayList<String>();
        if (messages != null) {
            for (String message : messages) {
                this.messages.add(message);
            }
        }
        this.metrics = new HashMap<String, Object>();
        if (metrics != null) {
            for (String key : metrics.keySet()) {
                this.metrics.put(key, metrics.get(key));
            }
        }
    }

    public static ElementState fromException(Throwable e) {
        return new ElementState(ElementStatus.INVALID, ElementState.messageFrom(e));
    }

    public static ElementState fromException(Throwable e, Map<String, Object> metrics) {
        return new ElementState(ElementStatus.INVALID, Collections.singletonList(ElementState.messageFrom(e)), metrics);
    }

    public static String messageFrom(Throwable e) {
        return e.getClass().getSimpleName() + ": " + e.getMessage();
    }

    public ElementState merge(ElementState other) {
        ArrayList<String> messages = new ArrayList<String>();
        messages.addAll(this.messages);
        messages.addAll(other.messages());
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.putAll(this.metrics);
        metrics.putAll(other.metrics());
        return new ElementState(ElementStatus.min(this.status, other.status), messages, metrics);
    }

    public boolean valid() {
        return this.valid;
    }

    public ElementStatus status() {
        return this.status;
    }

    public List<String> messages() {
        return this.messages;
    }

    public Map<String, Object> metrics() {
        return this.metrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ElementState)) {
            return false;
        }
        ElementState that = (ElementState)o;
        return Objects.equals((Object)this.status, (Object)that.status) && Objects.equals(this.messages, that.messages) && Objects.equals(this.metrics, that.metrics);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.messages, this.metrics});
    }

    public String toString() {
        return this.status.toString() + (this.messages.isEmpty() ? "!" : ": {" + Joiner.on((String)", ").join(this.messages) + "}") + (this.metrics.isEmpty() ? "" : " " + this.metrics);
    }
}

