/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.hibernate.criterion.Order;

public class EntityList<T>
implements Serializable,
Iterable<T> {
    private final List<T> entities;
    private final Long totalResults;
    private final Integer page;
    private final Integer pageSize;
    private final Iterable<Order> order;

    public static <T> EntityList<T> create(T ... entities) {
        return new EntityList<T>(Arrays.asList(entities));
    }

    public EntityList(List<T> entities) {
        this(entities, Long.valueOf(entities.size()), null, null, null);
    }

    public EntityList(List<T> entities, Long totalResults, Integer page, Integer pageSize, Iterable<Order> order) {
        this.entities = entities;
        this.totalResults = totalResults;
        this.page = page;
        this.pageSize = pageSize;
        this.order = order;
    }

    public List<T> getEntities() {
        return this.entities;
    }

    public Long getTotalResults() {
        return this.totalResults;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Iterable<Order> getOrder() {
        return this.order;
    }

    public T get(int pos) {
        return this.getEntities().get(pos);
    }

    public int size() {
        return this.entities.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.entities.iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.entities.forEach(action);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.entities.spliterator();
    }

    public Stream<T> stream() {
        return this.entities.stream();
    }

    public Stream<T> parallelStream() {
        return this.entities.parallelStream();
    }

    public String toString() {
        return String.valueOf(this.entities);
    }
}

