/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.intelie.live.util.TimestampOverwriteMap;

public class Event
extends ForwardingMap<String, Object>
implements Comparable<Event>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TIMESTAMP = "timestamp";
    public static final String TYPE = "__type";
    public static final String SRC = "__src";
    public static final String OVERWRITE = "__overwrite";
    public static final String SKIP_REALTIME = "__skiprealtime";
    public static final String SKIP_STORAGE = "__skipstorage";
    public static final String OLD_TIMESTAMP = "__oldTimestamp";
    private final String type;
    private final String src;
    private final Map<String, Object> data;
    private long timestamp;

    public Event(String type, String src, Map<String, Object> data) {
        this(type, src, data, true);
    }

    private Event(String type, String src, Map<String, Object> data, boolean copy) {
        Preconditions.checkNotNull((Object)type, (Object)"must have type");
        Preconditions.checkNotNull((Object)src, (Object)"must have source");
        Preconditions.checkNotNull(data, (Object)"must have data");
        this.timestamp = Event.maybeTimestamp(data.get(TIMESTAMP));
        this.type = Event.normalize(type);
        this.src = Event.normalize(src);
        if (copy) {
            this.data = new LinkedHashMap<String, Object>(data);
            this.data.put(TYPE, this.type);
            this.data.put(SRC, this.src);
        } else {
            this.data = data;
        }
    }

    public static Event fromMap(Map<String, Object> map) {
        Object typeObj = map.get(TYPE);
        Object srcObj = map.get(SRC);
        String type = typeObj instanceof String ? (String)typeObj : "unknown";
        String src = srcObj instanceof String ? (String)srcObj : "unknown";
        return new Event(type, src, map);
    }

    public static String normalize(String type) {
        return type == null ? null : type.toLowerCase(Locale.ROOT);
    }

    public Event copy() {
        return new Event(this.type, this.src, this.data);
    }

    public Event copy(long timestamp) {
        Event e = new Event(this.type, this.src, this.data);
        e.setTimestamp(timestamp);
        return e;
    }

    public Event forward(String timestamp) {
        if (TIMESTAMP.equals(timestamp)) {
            return this;
        }
        return new Event(this.type, this.src, new TimestampOverwriteMap(this.data, timestamp), false);
    }

    private static long maybeTimestamp(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return 0L;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        this.data.put(TIMESTAMP, timestamp);
    }

    public boolean isSystemEvent() {
        return this.type.startsWith("__");
    }

    public long timestamp() {
        return this.timestamp;
    }

    public String type() {
        return this.type;
    }

    public String source() {
        return this.src;
    }

    @Override
    public int compareTo(Event o) {
        if (o == null) {
            return 1;
        }
        return Long.compare(this.timestamp, o.timestamp());
    }

    public Map<String, Object> delegate() {
        return this.data;
    }

    public Map<String, Object> data() {
        return new LinkedHashMap<String, Object>(this.data);
    }

    public List<String> getOverwriteProps() {
        Object overwrite = this.get(OVERWRITE);
        if (Boolean.TRUE.equals(overwrite)) {
            return Collections.singletonList(TIMESTAMP);
        }
        if (overwrite instanceof String) {
            return Collections.singletonList(((String)overwrite).trim());
        }
        if (overwrite instanceof Iterable) {
            ArrayList<String> props = new ArrayList<String>();
            for (Object o : (Iterable)overwrite) {
                props.add(String.valueOf(o).trim());
            }
            return props;
        }
        return null;
    }
}

