/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.io.IOException;
import net.intelie.live.HtmlTagContext;

public interface HtmlTag {
    public void renderTo(Appendable var1, HtmlTagContext var2) throws IOException;

    public static class CssSnippet
    implements HtmlTag {
        private final String code;

        public CssSnippet(String code) {
            this.code = code;
        }

        @Override
        public void renderTo(Appendable out, HtmlTagContext context) throws IOException {
            out.append("<style>");
            out.append("/*<![CDATA[*/\n");
            out.append(this.code).append('\n');
            out.append("/*]]>*/\n");
            out.append("</style>");
            out.append("\n");
        }

        public String toString() {
            return "csssnippet:" + this.code.substring(0, Math.min(this.code.length(), 40));
        }
    }

    public static class JsSnippet
    implements HtmlTag {
        private final String code;

        public JsSnippet(String code) {
            this.code = code;
        }

        @Override
        public void renderTo(Appendable out, HtmlTagContext context) throws IOException {
            out.append("<script type='text/javascript'>");
            out.append("//<![CDATA[\n");
            out.append(this.code).append('\n');
            out.append("//]]>");
            out.append("</script>");
            out.append("\n");
        }

        public String toString() {
            return "jssnippet:" + this.code.substring(0, Math.min(this.code.length(), 40));
        }
    }

    public static class JsFile
    implements WithPath {
        private final String path;

        public JsFile(String path) {
            this.path = path;
        }

        @Override
        public void renderTo(Appendable out, HtmlTagContext context) throws IOException {
            out.append("<script type=\"text/javascript\" src=\"").append(context.modifyUrl(this.path)).append("\"></script>");
        }

        @Override
        public String path() {
            return this.path;
        }

        public String toString() {
            return "jsfile:" + this.path;
        }
    }

    public static class CssFile
    implements WithPath {
        private final String path;

        public CssFile(String path) {
            this.path = path;
        }

        @Override
        public void renderTo(Appendable out, HtmlTagContext context) throws IOException {
            out.append("<link href=\"").append(context.modifyUrl(this.path)).append("\" media=\"all\" rel=\"stylesheet\" type=\"text/css\"/>");
        }

        @Override
        public String path() {
            return this.path;
        }

        public String toString() {
            return "cssfile:" + this.path;
        }
    }

    public static enum Position {
        HEAD_BEGIN,
        HEAD_END,
        BODY_BEGIN,
        AFTER_BODY_HTML,
        BODY_END,
        BEGIN,
        END;

    }

    public static interface WithPath
    extends HtmlTag {
        public String path();
    }
}

