/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import java.sql.Driver;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import javax.servlet.Filter;
import net.intelie.live.App;
import net.intelie.live.AuthenticationProvider;
import net.intelie.live.AuthenticationProviderInfo;
import net.intelie.live.BayeuxQuery;
import net.intelie.live.DashboardTemplate;
import net.intelie.live.EmailProvider;
import net.intelie.live.EmailProviderInfo;
import net.intelie.live.EntityContext;
import net.intelie.live.EventLobby;
import net.intelie.live.EventSender;
import net.intelie.live.ExtensionType;
import net.intelie.live.HtmlTag;
import net.intelie.live.IndexDef;
import net.intelie.live.IndexInfo;
import net.intelie.live.LicenseInfo;
import net.intelie.live.LocalQueryMetadata;
import net.intelie.live.LoggedUser;
import net.intelie.live.LoginAuditor;
import net.intelie.live.LookupTable;
import net.intelie.live.MainStorageProvider;
import net.intelie.live.Metric;
import net.intelie.live.MetricInfo;
import net.intelie.live.NotificationProvider;
import net.intelie.live.NotificationProviderInfo;
import net.intelie.live.PeriodParser;
import net.intelie.live.PermissionDetails;
import net.intelie.live.PersistentExecutor;
import net.intelie.live.PersistentExecutorOptions;
import net.intelie.live.PrefixedLive;
import net.intelie.live.ProviderList;
import net.intelie.live.Query;
import net.intelie.live.QueryProvider;
import net.intelie.live.QueryProviderInfo;
import net.intelie.live.QueryRequest;
import net.intelie.live.QueryResponse;
import net.intelie.live.SecureEntityContext;
import net.intelie.live.SettingsRoot;
import net.intelie.live.StatementContext;
import net.intelie.live.StorageOptions;
import net.intelie.live.StorageProvider;
import net.intelie.live.StorageProviderInfo;
import net.intelie.live.UserManager;
import net.intelie.live.Version;
import net.intelie.live.WebRequestProxy;
import net.intelie.live.WidgetQueryHandler;
import net.intelie.pipes.FullPipe;
import net.intelie.pipes.Function;
import net.intelie.pipes.Module;
import net.intelie.pipes.PipeCompiler;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.time.Clock;
import net.intelie.pipes.time.ClockScheduler;
import org.springframework.context.ApplicationContext;
import org.springframework.security.web.authentication.RememberMeServices;

public interface Live {
    public Auth auth();

    public Web web();

    public Engine engine();

    public Pipes pipes();

    public Settings settings();

    public System system();

    public Time time();

    public Data data();

    public Index index();

    public Metrics metrics();

    public PrefixedLive newChild();

    public PrefixedLive newChild(ClassLoader var1);

    public PrefixedLive as(String var1);

    public Version liveVersion();

    public Version pluginVersion();

    public Action exportPackage(String var1) throws Exception;

    public Action describeAction(String var1, AutoCloseable var2) throws Exception;

    public Action describeAction(String var1, String var2, AutoCloseable var3) throws Exception;

    public PrefixedLive runGroovy(Reader var1) throws Exception;

    public PrefixedLive runGroovy(String var1) throws Exception;

    public List<Action> actions();

    public static interface Metrics {
        public Action addMetric(MetricInfo var1, Metric var2) throws Exception;

        public Action addGroup(MetricInfo var1) throws Exception;

        public Action addGroupMetric(String var1, String var2, Metric var3) throws Exception;

        public Object getValue(String var1);

        public Object getGroupValue(String var1, String var2);
    }

    public static interface Auth {
        public Action addAuthenticationProvider(String var1, AuthenticationProvider var2) throws Exception;

        public ProviderList<AuthenticationProviderInfo> getAuthenticationProviders() throws Exception;

        public Action addPermission(PermissionDetails var1) throws Exception;

        public Action addExceptionFilter(String var1, Filter var2) throws Exception;

        public Action addSecurityFilter(String var1, Filter var2) throws Exception;

        public Action addAuthenticationButton(String var1, String var2, String var3) throws Exception;

        public RememberMeServices getRememberMe() throws Exception;

        public UserManager getUserManager() throws Exception;

        public LoggedUser getLoggedUser() throws Exception;

        public LoginAuditor getLoginAuditor() throws Exception;

        public String resolveSecurityFilterUrl(String var1);
    }

    public static interface Pipes {
        public Action addInstanceModule(Object var1) throws Exception;

        public Action addStaticModule(Class<?> var1) throws Exception;

        public Action addInstanceModule(Object var1, ClassLoader var2) throws Exception;

        public Action addStaticModule(Class<?> var1, ClassLoader var2) throws Exception;

        public Action addConstructor(Class<?> var1) throws Exception;

        public Action addConstructor(String var1, Class<?> var2) throws Exception;

        public Action addModule(Module var1) throws Exception;

        public Action addFunction(Function var1) throws Exception;

        public PipeCompiler<FullPipe> compiler();

        public PipeCompiler<FullPipe> compilerExcept(Set<Module> var1) throws PipeException;
    }

    public static interface Engine {
        public StatementContext newStatementContext();

        public Action addExtensionType(ExtensionType<?> var1) throws Exception;

        public Action addQueryProvider(String var1, QueryProvider var2) throws Exception;

        public Action addStorageProvider(String var1, StorageProvider var2, StorageOptions var3) throws Exception;

        public Action addNotificationProvider(String var1, NotificationProvider var2) throws Exception;

        public Action addEmailProvider(String var1, EmailProvider var2, ExecutorService var3) throws Exception;

        public MainStorageProvider getMainStorage() throws Exception;

        public ProviderList<QueryProviderInfo> getQueryProviders() throws Exception;

        public ProviderList<StorageProviderInfo> getStorageProviders() throws Exception;

        public ProviderList<NotificationProviderInfo> getNotificationProviders() throws Exception;

        public EmailProvider getMainEmailProvider() throws Exception;

        public ProviderList<EmailProviderInfo> getEmailProviders() throws Exception;

        public Action addLookupTable(LookupTable var1) throws Exception;

        public LookupTable getLookupTable(String var1) throws Exception;

        public Action runQueries(Query ... var1) throws Exception;

        public List<QueryResponse> registerBayeuxQueries(String var1, QueryRequest ... var2) throws Exception;

        public List<QueryResponse> registerBayeuxQuery(BayeuxQuery var1) throws Exception;

        public EventLobby getEventLobby() throws Exception;

        public EventSender getStatusSender() throws Exception;

        public LocalQueryMetadata analyzeQuery(Query var1) throws Exception;
    }

    public static interface Web {
        public String getSystemUrl() throws Exception;

        public Action addApp(App var1) throws Exception;

        public Action addContent(String var1, URL var2) throws Exception;

        public Action addService(String var1, Object var2) throws Exception;

        public Action addOpenService(String var1, Object var2) throws Exception;

        public Action addTag(HtmlTag.Position var1, HtmlTag var2) throws Exception;

        public Action addShortScript(String var1) throws Exception;

        public Action addShortScript(String var1, String var2) throws Exception;

        public Action addMainAssets(URL var1) throws Exception;

        public Action addDashboardTemplate(DashboardTemplate var1) throws Exception;

        public Action addWidgetQueryHandler(String var1, WidgetQueryHandler var2) throws Exception;

        public WebRequestProxy getRequestProxy() throws Exception;

        public String resolveContent(String var1);

        public String resolveService(String var1);

        public String resolveOpenService(String var1);
    }

    public static interface Action
    extends AutoCloseable {
        public String description();

        public String prefix();

        public String url();

        public void undo();

        public void redo();
    }

    public static interface System {
        public ClassLoader classloader();

        public ClockScheduler requestScheduler(int var1, String var2) throws Exception;

        public ScheduledExecutorService requestScheduledExecutor(int var1, String var2) throws Exception;

        public ExecutorService requestExecutor(int var1, int var2, String var3) throws Exception;

        public ExecutorService requestExecutor(int var1, int var2, String var3, boolean var4) throws Exception;

        public ExecutorService requestUnsafeExecutor(String var1) throws Exception;

        public <T> PersistentExecutor<T> requestPersistentExecutor(String var1, PersistentExecutorOptions<T> var2, Consumer<T> var3) throws Exception;

        public Action addJdbcDriver(Driver var1) throws Exception;

        public Path newTempDirectory() throws Exception;

        public Path getDataDirectory() throws Exception;

        public ApplicationContext getSpringContext() throws Exception;

        public <T> Action registerPluginService(Class<T> var1, T var2) throws Exception;

        public <T> T getPluginService(Class<T> var1) throws Exception;

        public LicenseInfo getLicenseInfo() throws Exception;
    }

    public static interface Time {
        public Clock clock();

        public PeriodParser getPeriodParser();

        public PeriodParser getPeriodParser(TimeZone var1);
    }

    public static interface Index {
        public Action registerIndex(IndexDef var1) throws Exception;

        public void createIndexNow(IndexDef var1) throws Exception;

        public void createIndexAsync(IndexDef var1) throws Exception;

        public IndexInfo checkIndex(IndexDef var1) throws Exception;
    }

    public static interface Data {
        public EntityContext getContext() throws Exception;

        public SecureEntityContext getSecureContext() throws Exception;
    }

    @Deprecated
    public static interface Settings
    extends SettingsRoot {
    }
}

