/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import net.intelie.live.ExtensionArea;
import net.intelie.live.Query;

public abstract class LiveUrls {
    public static String datasource(Integer id) {
        if (id == null) {
            return null;
        }
        return "/#config/datasource/" + id;
    }

    public static String rule(Integer id) {
        if (id == null) {
            return null;
        }
        return "/#monitoring/rule/" + id;
    }

    public static String stream(Integer id) {
        if (id == null) {
            return null;
        }
        return "/#config/stream/" + id;
    }

    public static String user(Integer id) {
        if (id == null) {
            return null;
        }
        return "/admin#user/" + id;
    }

    public static String team(Integer id) {
        if (id == null) {
            return null;
        }
        return "/admin#team/" + id;
    }

    public static String role(Integer id) {
        if (id == null) {
            return null;
        }
        return "/admin#role/" + id;
    }

    public static String notification(Integer id) {
        if (id == null) {
            return null;
        }
        return "/admin#notification/" + id;
    }

    public static String app(String key) {
        if (key == null) {
            return null;
        }
        return "/app/" + key;
    }

    public static String widget(Integer id) {
        if (id == null) {
            return null;
        }
        return "/widget/" + id + "/#/edit";
    }

    public static String perspective(Integer id) {
        if (id == null) {
            return null;
        }
        return "/config#perspective/" + id;
    }

    public static String lookupTable(String key) {
        if (key == null) {
            return null;
        }
        return "/#config/lookup-table/" + key;
    }

    public static String dashboard(Integer id) {
        return LiveUrls.dashboard(id, null);
    }

    public static String dashboard(Integer id, String token) {
        if (id == null) {
            return null;
        }
        String url = "/dashboard/" + id;
        if (token != null && !token.isEmpty()) {
            url = url + "?auth=" + LiveUrls.escape(token);
        }
        return url;
    }

    public static String extension(ExtensionArea area, String type, Integer id) {
        if (id == null || area == null || type == null) {
            return null;
        }
        return LiveUrls.extensionArea(area) + "/" + type + "/" + id;
    }

    public static String extensionType(ExtensionArea area, String type) {
        if (area == null || type == null) {
            return null;
        }
        return LiveUrls.extensionArea(area) + "/" + type;
    }

    public static String extensionRedirect(String type, String qualifier) {
        if (type == null) {
            return null;
        }
        if (qualifier == null) {
            return "/rest/extension/redirect/" + type;
        }
        return "/rest/extension/redirect/" + type + "/" + qualifier;
    }

    public static String extensionRedirect(String fullQualifier) {
        if (fullQualifier == null) {
            return null;
        }
        return "/rest/extension/redirect/" + fullQualifier;
    }

    public static String extensionArea(ExtensionArea area) {
        if (area == null) {
            return null;
        }
        String name = area == ExtensionArea.PLATFORM ? area.toString().toLowerCase(Locale.ROOT) : area.toString().toLowerCase(Locale.ROOT) + "s";
        return "/admin#/" + name;
    }

    public static String plugins() {
        return "/admin#plugins";
    }

    public static String console() {
        return "/#console";
    }

    public static String console(Query query) {
        return String.format((Locale)null, "/#console?provider=%s&expression=%s&span=%s&follow=%s&preload=%s&chart=false", LiveUrls.escape(LiveUrls.escape(query.getProvider())), LiveUrls.escape(LiveUrls.escape(query.getExpression())), LiveUrls.escape(LiveUrls.escape(query.getSpan())), query.getFollow(), query.getPreloadWindow());
    }

    public static String escape(String s) {
        return LiveUrls.escape(s, "UTF-8");
    }

    public static String escape(String s, String enc) {
        try {
            return URLEncoder.encode(s, enc).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }
}

