/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.util.Collection;
import java.util.Objects;
import org.springframework.security.core.GrantedAuthority;

public class LoginSuccessEvent {
    private final String provider;
    private final String user;
    private final String remoteAddr;
    private final String sessionId;
    private final Collection<? extends GrantedAuthority> authorities;

    public LoginSuccessEvent(String provider, String user, String remoteAddr, String sessionId, Collection<? extends GrantedAuthority> authorities) {
        this.provider = provider;
        this.user = user;
        this.remoteAddr = remoteAddr;
        this.sessionId = sessionId;
        this.authorities = authorities;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getUser() {
        return this.user;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoginSuccessEvent that = (LoginSuccessEvent)o;
        return Objects.equals(this.provider, that.provider) && Objects.equals(this.user, that.user) && Objects.equals(this.remoteAddr, that.remoteAddr) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.authorities, that.authorities);
    }

    public int hashCode() {
        return Objects.hash(this.provider, this.user, this.remoteAddr, this.sessionId, this.authorities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LoginSuccessEvent{");
        sb.append("provider='").append(this.provider).append('\'');
        sb.append(", user='").append(this.user).append('\'');
        sb.append(", remoteAddr='").append(this.remoteAddr).append('\'');
        sb.append(", sessionId='").append(this.sessionId).append('\'');
        sb.append(", authorities=").append(this.authorities);
        sb.append('}');
        return sb.toString();
    }
}

