/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.intelie.live.Lookup;

public class MapLookup
implements Lookup,
Serializable {
    public static final long serialVersionUID = 1L;
    private final Map<String, List<Object>> map;

    public MapLookup(Lookup.Entry ... entries) {
        this(Arrays.asList(entries));
    }

    public MapLookup(Iterable<? extends Lookup.Entry> entries) {
        this(MapLookup.makeMap(entries));
    }

    public MapLookup(Map<String, List<Object>> map) {
        this.map = map;
    }

    private static Map<String, List<Object>> makeMap(Iterable<? extends Lookup.Entry> entries) {
        LinkedHashMap<String, List<Object>> map = new LinkedHashMap<String, List<Object>>();
        for (Lookup.Entry entry : entries) {
            List list = map.computeIfAbsent(entry.getKey(), k -> new ArrayList());
            list.add(entry.getValue());
        }
        return map;
    }

    @Override
    public Object get(String key) {
        List<Object> list = this.map.get(key);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<Object> getMany(String key) {
        List<Object> list = this.map.get(key);
        if (list == null) {
            return null;
        }
        return new ArrayList<Object>(list);
    }

    @Override
    public List<Lookup.Entry> all() {
        ArrayList<Lookup.Entry> list = new ArrayList<Lookup.Entry>(this.map.size());
        for (Map.Entry<String, List<Object>> entry : this.map.entrySet()) {
            if (entry.getValue() == null) continue;
            for (Object obj : entry.getValue()) {
                list.add(new Lookup.Entry(entry.getKey(), obj));
            }
        }
        return list;
    }

    public String toString() {
        return "lookup:" + this.map.toString();
    }
}

