/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;

public abstract class MimeTypes {
    public static final String MIME_APPLICATION_ANDREW_INSET = "application/andrew-inset";
    public static final String MIME_APPLICATION_JSON = "application/json";
    public static final String MIME_APPLICATION_ZIP = "application/zip";
    public static final String MIME_APPLICATION_X_GZIP = "application/x-gzip";
    public static final String MIME_APPLICATION_TGZ = "application/tgz";
    public static final String MIME_APPLICATION_MSWORD = "application/msword";
    public static final String MIME_APPLICATION_POSTSCRIPT = "application/postscript";
    public static final String MIME_APPLICATION_PDF = "application/pdf";
    public static final String MIME_APPLICATION_JNLP = "application/jnlp";
    public static final String MIME_APPLICATION_MAC_BINHEX40 = "application/mac-binhex40";
    public static final String MIME_APPLICATION_MAC_COMPACTPRO = "application/mac-compactpro";
    public static final String MIME_APPLICATION_MATHML_XML = "application/mathml+xml";
    public static final String MIME_APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String MIME_APPLICATION_ODA = "application/oda";
    public static final String MIME_APPLICATION_RDF_XML = "application/rdf+xml";
    public static final String MIME_APPLICATION_JAVA_ARCHIVE = "application/java-archive";
    public static final String MIME_APPLICATION_RDF_SMIL = "application/smil";
    public static final String MIME_APPLICATION_SRGS = "application/srgs";
    public static final String MIME_APPLICATION_SRGS_XML = "application/srgs+xml";
    public static final String MIME_APPLICATION_VND_MIF = "application/vnd.mif";
    public static final String MIME_APPLICATION_VND_MSEXCEL = "application/vnd.ms-excel";
    public static final String MIME_APPLICATION_VND_MSPOWERPOINT = "application/vnd.ms-powerpoint";
    public static final String MIME_APPLICATION_VND_RNREALMEDIA = "application/vnd.rn-realmedia";
    public static final String MIME_APPLICATION_X_BCPIO = "application/x-bcpio";
    public static final String MIME_APPLICATION_X_CDLINK = "application/x-cdlink";
    public static final String MIME_APPLICATION_X_CHESS_PGN = "application/x-chess-pgn";
    public static final String MIME_APPLICATION_X_CPIO = "application/x-cpio";
    public static final String MIME_APPLICATION_X_CSH = "application/x-csh";
    public static final String MIME_APPLICATION_X_DIRECTOR = "application/x-director";
    public static final String MIME_APPLICATION_X_DVI = "application/x-dvi";
    public static final String MIME_APPLICATION_X_FUTURESPLASH = "application/x-futuresplash";
    public static final String MIME_APPLICATION_X_GTAR = "application/x-gtar";
    public static final String MIME_APPLICATION_X_HDF = "application/x-hdf";
    public static final String MIME_APPLICATION_X_JAVASCRIPT = "application/x-javascript";
    public static final String MIME_APPLICATION_X_KOAN = "application/x-koan";
    public static final String MIME_APPLICATION_X_LATEX = "application/x-latex";
    public static final String MIME_APPLICATION_X_NETCDF = "application/x-netcdf";
    public static final String MIME_APPLICATION_X_OGG = "application/x-ogg";
    public static final String MIME_APPLICATION_X_SH = "application/x-sh";
    public static final String MIME_APPLICATION_X_SHAR = "application/x-shar";
    public static final String MIME_APPLICATION_X_SHOCKWAVE_FLASH = "application/x-shockwave-flash";
    public static final String MIME_APPLICATION_X_STUFFIT = "application/x-stuffit";
    public static final String MIME_APPLICATION_X_SV4CPIO = "application/x-sv4cpio";
    public static final String MIME_APPLICATION_X_SV4CRC = "application/x-sv4crc";
    public static final String MIME_APPLICATION_X_TAR = "application/x-tar";
    public static final String MIME_APPLICATION_X_RAR_COMPRESSED = "application/x-rar-compressed";
    public static final String MIME_APPLICATION_X_TCL = "application/x-tcl";
    public static final String MIME_APPLICATION_X_TEX = "application/x-tex";
    public static final String MIME_APPLICATION_X_TEXINFO = "application/x-texinfo";
    public static final String MIME_APPLICATION_X_TROFF = "application/x-troff";
    public static final String MIME_APPLICATION_X_TROFF_MAN = "application/x-troff-man";
    public static final String MIME_APPLICATION_X_TROFF_ME = "application/x-troff-me";
    public static final String MIME_APPLICATION_X_TROFF_MS = "application/x-troff-ms";
    public static final String MIME_APPLICATION_X_USTAR = "application/x-ustar";
    public static final String MIME_APPLICATION_X_WAIS_SOURCE = "application/x-wais-source";
    public static final String MIME_APPLICATION_VND_MOZZILLA_XUL_XML = "application/vnd.mozilla.xul+xml";
    public static final String MIME_APPLICATION_XHTML_XML = "application/xhtml+xml";
    public static final String MIME_APPLICATION_XSLT_XML = "application/xslt+xml";
    public static final String MIME_APPLICATION_XML = "application/xml";
    public static final String MIME_APPLICATION_XML_DTD = "application/xml-dtd";
    public static final String MIME_IMAGE_BMP = "image/bmp";
    public static final String MIME_IMAGE_CGM = "image/cgm";
    public static final String MIME_IMAGE_GIF = "image/gif";
    public static final String MIME_IMAGE_IEF = "image/ief";
    public static final String MIME_IMAGE_JPEG = "image/jpeg";
    public static final String MIME_IMAGE_TIFF = "image/tiff";
    public static final String MIME_IMAGE_PNG = "image/png";
    public static final String MIME_IMAGE_SVG_XML = "image/svg+xml";
    public static final String MIME_IMAGE_VND_DJVU = "image/vnd.djvu";
    public static final String MIME_IMAGE_WAP_WBMP = "image/vnd.wap.wbmp";
    public static final String MIME_IMAGE_X_CMU_RASTER = "image/x-cmu-raster";
    public static final String MIME_IMAGE_X_ICON = "image/x-icon";
    public static final String MIME_IMAGE_X_PORTABLE_ANYMAP = "image/x-portable-anymap";
    public static final String MIME_IMAGE_X_PORTABLE_BITMAP = "image/x-portable-bitmap";
    public static final String MIME_IMAGE_X_PORTABLE_GRAYMAP = "image/x-portable-graymap";
    public static final String MIME_IMAGE_X_PORTABLE_PIXMAP = "image/x-portable-pixmap";
    public static final String MIME_IMAGE_X_RGB = "image/x-rgb";
    public static final String MIME_AUDIO_BASIC = "audio/basic";
    public static final String MIME_AUDIO_MIDI = "audio/midi";
    public static final String MIME_AUDIO_MPEG = "audio/mpeg";
    public static final String MIME_AUDIO_X_AIFF = "audio/x-aiff";
    public static final String MIME_AUDIO_X_MPEGURL = "audio/x-mpegurl";
    public static final String MIME_AUDIO_X_PN_REALAUDIO = "audio/x-pn-realaudio";
    public static final String MIME_AUDIO_X_WAV = "audio/x-wav";
    public static final String MIME_CHEMICAL_X_PDB = "chemical/x-pdb";
    public static final String MIME_CHEMICAL_X_XYZ = "chemical/x-xyz";
    public static final String MIME_MODEL_IGES = "model/iges";
    public static final String MIME_MODEL_MESH = "model/mesh";
    public static final String MIME_MODEL_VRLM = "model/vrml";
    public static final String MIME_TEXT_PLAIN = "text/plain";
    public static final String MIME_TEXT_RICHTEXT = "text/richtext";
    public static final String MIME_TEXT_RTF = "text/rtf";
    public static final String MIME_TEXT_HTML = "text/html";
    public static final String MIME_TEXT_CALENDAR = "text/calendar";
    public static final String MIME_TEXT_CSS = "text/css";
    public static final String MIME_TEXT_SGML = "text/sgml";
    public static final String MIME_TEXT_TAB_SEPARATED_VALUES = "text/tab-separated-values";
    public static final String MIME_TEXT_VND_WAP_XML = "text/vnd.wap.wml";
    public static final String MIME_TEXT_VND_WAP_WMLSCRIPT = "text/vnd.wap.wmlscript";
    public static final String MIME_TEXT_X_SETEXT = "text/x-setext";
    public static final String MIME_TEXT_X_COMPONENT = "text/x-component";
    public static final String MIME_VIDEO_QUICKTIME = "video/quicktime";
    public static final String MIME_VIDEO_MPEG = "video/mpeg";
    public static final String MIME_VIDEO_VND_MPEGURL = "video/vnd.mpegurl";
    public static final String MIME_VIDEO_X_MSVIDEO = "video/x-msvideo";
    public static final String MIME_VIDEO_X_MS_WMV = "video/x-ms-wmv";
    public static final String MIME_VIDEO_X_SGI_MOVIE = "video/x-sgi-movie";
    public static final String MIME_X_CONFERENCE_X_COOLTALK = "x-conference/x-cooltalk";
    private static final ImmutableMap<String, String> mimeTypeMapping = ImmutableMap.builder().put((Object)"xul", (Object)"application/vnd.mozilla.xul+xml").put((Object)"json", (Object)"application/json").put((Object)"ice", (Object)"x-conference/x-cooltalk").put((Object)"movie", (Object)"video/x-sgi-movie").put((Object)"avi", (Object)"video/x-msvideo").put((Object)"wmv", (Object)"video/x-ms-wmv").put((Object)"m4u", (Object)"video/vnd.mpegurl").put((Object)"mxu", (Object)"video/vnd.mpegurl").put((Object)"htc", (Object)"text/x-component").put((Object)"etx", (Object)"text/x-setext").put((Object)"wmls", (Object)"text/vnd.wap.wmlscript").put((Object)"wml", (Object)"text/vnd.wap.wml").put((Object)"tsv", (Object)"text/tab-separated-values").put((Object)"sgm", (Object)"text/sgml").put((Object)"sgml", (Object)"text/sgml").put((Object)"css", (Object)"text/css").put((Object)"ifb", (Object)"text/calendar").put((Object)"ics", (Object)"text/calendar").put((Object)"wrl", (Object)"model/vrml").put((Object)"vrlm", (Object)"model/vrml").put((Object)"silo", (Object)"model/mesh").put((Object)"mesh", (Object)"model/mesh").put((Object)"msh", (Object)"model/mesh").put((Object)"iges", (Object)"model/iges").put((Object)"igs", (Object)"model/iges").put((Object)"rgb", (Object)"image/x-rgb").put((Object)"ppm", (Object)"image/x-portable-pixmap").put((Object)"pgm", (Object)"image/x-portable-graymap").put((Object)"pbm", (Object)"image/x-portable-bitmap").put((Object)"pnm", (Object)"image/x-portable-anymap").put((Object)"ico", (Object)"image/x-icon").put((Object)"ras", (Object)"image/x-cmu-raster").put((Object)"wbmp", (Object)"image/vnd.wap.wbmp").put((Object)"djv", (Object)"image/vnd.djvu").put((Object)"djvu", (Object)"image/vnd.djvu").put((Object)"svg", (Object)"image/svg+xml").put((Object)"ief", (Object)"image/ief").put((Object)"cgm", (Object)"image/cgm").put((Object)"bmp", (Object)"image/bmp").put((Object)"xyz", (Object)"chemical/x-xyz").put((Object)"pdb", (Object)"chemical/x-pdb").put((Object)"ra", (Object)"audio/x-pn-realaudio").put((Object)"ram", (Object)"audio/x-pn-realaudio").put((Object)"m3u", (Object)"audio/x-mpegurl").put((Object)"aifc", (Object)"audio/x-aiff").put((Object)"aif", (Object)"audio/x-aiff").put((Object)"aiff", (Object)"audio/x-aiff").put((Object)"mp3", (Object)"audio/mpeg").put((Object)"mp2", (Object)"audio/mpeg").put((Object)"mp1", (Object)"audio/mpeg").put((Object)"mpga", (Object)"audio/mpeg").put((Object)"kar", (Object)"audio/midi").put((Object)"mid", (Object)"audio/midi").put((Object)"midi", (Object)"audio/midi").put((Object)"dtd", (Object)"application/xml-dtd").put((Object)"xsl", (Object)"application/xml").put((Object)"xml", (Object)"application/xml").put((Object)"xslt", (Object)"application/xslt+xml").put((Object)"xht", (Object)"application/xhtml+xml").put((Object)"xhtml", (Object)"application/xhtml+xml").put((Object)"src", (Object)"application/x-wais-source").put((Object)"ustar", (Object)"application/x-ustar").put((Object)"ms", (Object)"application/x-troff-ms").put((Object)"me", (Object)"application/x-troff-me").put((Object)"man", (Object)"application/x-troff-man").put((Object)"roff", (Object)"application/x-troff").put((Object)"tr", (Object)"application/x-troff").put((Object)"t", (Object)"application/x-troff").put((Object)"texi", (Object)"application/x-texinfo").put((Object)"texinfo", (Object)"application/x-texinfo").put((Object)"tex", (Object)"application/x-tex").put((Object)"tcl", (Object)"application/x-tcl").put((Object)"sv4crc", (Object)"application/x-sv4crc").put((Object)"sv4cpio", (Object)"application/x-sv4cpio").put((Object)"sit", (Object)"application/x-stuffit").put((Object)"swf", (Object)"application/x-shockwave-flash").put((Object)"shar", (Object)"application/x-shar").put((Object)"sh", (Object)"application/x-sh").put((Object)"cdf", (Object)"application/x-netcdf").put((Object)"nc", (Object)"application/x-netcdf").put((Object)"latex", (Object)"application/x-latex").put((Object)"skm", (Object)"application/x-koan").put((Object)"skt", (Object)"application/x-koan").put((Object)"skd", (Object)"application/x-koan").put((Object)"skp", (Object)"application/x-koan").put((Object)"js", (Object)"application/x-javascript").put((Object)"hdf", (Object)"application/x-hdf").put((Object)"gtar", (Object)"application/x-gtar").put((Object)"spl", (Object)"application/x-futuresplash").put((Object)"dvi", (Object)"application/x-dvi").put((Object)"dxr", (Object)"application/x-director").put((Object)"dir", (Object)"application/x-director").put((Object)"dcr", (Object)"application/x-director").put((Object)"csh", (Object)"application/x-csh").put((Object)"cpio", (Object)"application/x-cpio").put((Object)"pgn", (Object)"application/x-chess-pgn").put((Object)"vcd", (Object)"application/x-cdlink").put((Object)"bcpio", (Object)"application/x-bcpio").put((Object)"rm", (Object)"application/vnd.rn-realmedia").put((Object)"ppt", (Object)"application/vnd.ms-powerpoint").put((Object)"mif", (Object)"application/vnd.mif").put((Object)"grxml", (Object)"application/srgs+xml").put((Object)"gram", (Object)"application/srgs").put((Object)"smil", (Object)"application/smil").put((Object)"smi", (Object)"application/smil").put((Object)"rdf", (Object)"application/rdf+xml").put((Object)"ogg", (Object)"application/x-ogg").put((Object)"oda", (Object)"application/oda").put((Object)"dmg", (Object)"application/octet-stream").put((Object)"lzh", (Object)"application/octet-stream").put((Object)"so", (Object)"application/octet-stream").put((Object)"lha", (Object)"application/octet-stream").put((Object)"dms", (Object)"application/octet-stream").put((Object)"bin", (Object)"application/octet-stream").put((Object)"mathml", (Object)"application/mathml+xml").put((Object)"cpt", (Object)"application/mac-compactpro").put((Object)"hqx", (Object)"application/mac-binhex40").put((Object)"jnlp", (Object)"application/jnlp").put((Object)"ez", (Object)"application/andrew-inset").put((Object)"txt", (Object)"text/plain").put((Object)"ini", (Object)"text/plain").put((Object)"c", (Object)"text/plain").put((Object)"h", (Object)"text/plain").put((Object)"cpp", (Object)"text/plain").put((Object)"cxx", (Object)"text/plain").put((Object)"cc", (Object)"text/plain").put((Object)"chh", (Object)"text/plain").put((Object)"java", (Object)"text/plain").put((Object)"csv", (Object)"text/plain").put((Object)"bat", (Object)"text/plain").put((Object)"cmd", (Object)"text/plain").put((Object)"asc", (Object)"text/plain").put((Object)"rtf", (Object)"text/rtf").put((Object)"rtx", (Object)"text/richtext").put((Object)"html", (Object)"text/html").put((Object)"htm", (Object)"text/html").put((Object)"zip", (Object)"application/zip").put((Object)"rar", (Object)"application/x-rar-compressed").put((Object)"gzip", (Object)"application/x-gzip").put((Object)"gz", (Object)"application/x-gzip").put((Object)"tgz", (Object)"application/tgz").put((Object)"tar", (Object)"application/x-tar").put((Object)"gif", (Object)"image/gif").put((Object)"jpeg", (Object)"image/jpeg").put((Object)"jpg", (Object)"image/jpeg").put((Object)"jpe", (Object)"image/jpeg").put((Object)"tiff", (Object)"image/tiff").put((Object)"tif", (Object)"image/tiff").put((Object)"png", (Object)"image/png").put((Object)"au", (Object)"audio/basic").put((Object)"snd", (Object)"audio/basic").put((Object)"wav", (Object)"audio/x-wav").put((Object)"mov", (Object)"video/quicktime").put((Object)"qt", (Object)"video/quicktime").put((Object)"mpeg", (Object)"video/mpeg").put((Object)"mpg", (Object)"video/mpeg").put((Object)"mpe", (Object)"video/mpeg").put((Object)"abs", (Object)"video/mpeg").put((Object)"doc", (Object)"application/msword").put((Object)"xls", (Object)"application/vnd.ms-excel").put((Object)"eps", (Object)"application/postscript").put((Object)"ai", (Object)"application/postscript").put((Object)"ps", (Object)"application/postscript").put((Object)"pdf", (Object)"application/pdf").put((Object)"exe", (Object)"application/octet-stream").put((Object)"dll", (Object)"application/octet-stream").put((Object)"class", (Object)"application/octet-stream").put((Object)"jar", (Object)"application/java-archive").build();

    public static String getMimeType(String file) {
        String mimeType = MimeTypes.lookupMimeType(file);
        if (mimeType == null) {
            mimeType = MIME_APPLICATION_OCTET_STREAM;
        }
        return mimeType;
    }

    public static String lookupMimeType(String file) {
        String ext = file.substring(file.lastIndexOf(46) + 1);
        return (String)mimeTypeMapping.get((Object)ext.toLowerCase(Locale.ROOT));
    }
}

