/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.util.List;
import java.util.Objects;
import net.intelie.live.ControlEvent;

public class PerformanceInfo
extends ControlEvent {
    private final long count;
    private final long time;
    private final List<Storage> storage;
    private final List<Live> live;

    public PerformanceInfo(long count, long time, List<Storage> storage, List<Live> live) {
        super("performance", null);
        this.count = count;
        this.time = time;
        this.storage = storage;
        this.live = live;
    }

    public long getCount() {
        return this.count;
    }

    public long getTime() {
        return this.time;
    }

    public List<Storage> getStorage() {
        return this.storage;
    }

    public List<Live> getLive() {
        return this.live;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PerformanceInfo)) {
            return false;
        }
        PerformanceInfo that = (PerformanceInfo)o;
        return Objects.equals(this.count, that.count) && Objects.equals(this.time, that.time) && Objects.equals(this.storage, that.storage) && Objects.equals(this.live, that.live) && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.count, this.time, this.storage, this.live, super.hashCode());
    }

    @Override
    public String toString() {
        return this.makeStringFor("count", this.count, "time", this.time, "storage", this.storage, "live", this.live);
    }

    public static class Live {
        private final String q;
        private final String url;
        private final long flowCount;
        private final long flowTime;
        private final long miscCount;
        private final long miscTime;

        public Live(String q, String url, long flowCount, long flowTime, long miscCount, long miscTime) {
            this.q = q;
            this.url = url;
            this.flowCount = flowCount;
            this.flowTime = flowTime;
            this.miscCount = miscCount;
            this.miscTime = miscTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Live live = (Live)o;
            return this.flowCount == live.flowCount && this.flowTime == live.flowTime && this.miscCount == live.miscCount && this.miscTime == live.miscTime && Objects.equals(this.q, live.q) && Objects.equals(this.url, live.url);
        }

        public int hashCode() {
            return Objects.hash(this.q, this.url, this.flowCount, this.flowTime, this.miscCount, this.miscTime);
        }

        public String toString() {
            return "Live{q=\"" + this.q + '\"' + ", url=\"" + this.url + '\"' + ", flowCount=" + this.flowCount + ", flowTime=" + this.flowTime + ", miscCount=" + this.miscCount + ", miscTime=" + this.miscTime + '}';
        }
    }

    public static class Storage {
        private final String q;
        private final String intervals;
        private final long expectedEvents;
        private final long actualEvents;
        private final long initCount;
        private final long initTime;
        private final long readCount;
        private final long readTime;
        private final long filterCount;
        private final long filterTime;
        private final long cacheReads;
        private final long cacheWrites;

        public Storage(String q, String intervals, long expectedEvents, long actualEvents, long initCount, long initTime, long readCount, long readTime, long filterCount, long filterTime, long cacheReads, long cacheWrites) {
            this.q = q;
            this.intervals = intervals;
            this.expectedEvents = expectedEvents;
            this.actualEvents = actualEvents;
            this.initCount = initCount;
            this.initTime = initTime;
            this.readCount = readCount;
            this.readTime = readTime;
            this.filterCount = filterCount;
            this.filterTime = filterTime;
            this.cacheReads = cacheReads;
            this.cacheWrites = cacheWrites;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Storage storage = (Storage)o;
            return this.expectedEvents == storage.expectedEvents && this.actualEvents == storage.actualEvents && this.initCount == storage.initCount && this.initTime == storage.initTime && this.readCount == storage.readCount && this.readTime == storage.readTime && this.filterCount == storage.filterCount && this.filterTime == storage.filterTime && this.cacheReads == storage.cacheReads && this.cacheWrites == storage.cacheWrites && Objects.equals(this.intervals, storage.intervals) && Objects.equals(this.q, storage.q);
        }

        public int hashCode() {
            return Objects.hash(this.q, this.intervals, this.expectedEvents, this.actualEvents, this.initCount, this.initTime, this.readCount, this.readTime, this.cacheReads, this.cacheWrites);
        }

        public String toString() {
            return "Storage{q=\"" + this.q + '\"' + ", intervals=\"" + this.intervals + '\"' + ", expectedEvents=" + this.expectedEvents + ", actualEvents=" + this.actualEvents + ", initCount=" + this.initCount + ", initTime=" + this.initTime + ", readCount=" + this.readCount + ", readTime=" + this.readTime + ", filterCount=" + this.filterCount + ", filterTime=" + this.filterTime + ", cacheReads=" + this.cacheReads + ", cacheWrites=" + this.cacheWrites + '}';
        }
    }
}

