/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import net.intelie.disq.DefaultSerializer;
import net.intelie.disq.DisqBuilder;
import net.intelie.disq.SerializerFactory;

public class PersistentExecutorOptions<T> {
    public final DefaultSerializer<T> DEFAULT_SERIALIZER = new DefaultSerializer();
    private long maxSize;
    private SerializerFactory<T> serializer = this.DEFAULT_SERIALIZER;
    private boolean flushOnPop = false;
    private boolean flushOnPush = false;
    private long autoFlushMs = 1000L;
    private boolean deleteOldestOnOverflow = true;
    private int initialBufferCapacity = 4096;
    private int maxBufferCapacity = 0x800000;
    private int fallbackBufferCapacity = 0x800000;
    private int threadCount = 1;

    public PersistentExecutorOptions(long maxSize) {
        this.maxSize = maxSize;
    }

    public PersistentExecutorOptions<T> setSerializer(SerializerFactory<T> serializer) {
        this.serializer = serializer;
        return this;
    }

    public PersistentExecutorOptions<T> setFlushOnPop(boolean flushOnPop) {
        this.flushOnPop = flushOnPop;
        return this;
    }

    public PersistentExecutorOptions<T> setFlushOnPush(boolean flushOnPush) {
        this.flushOnPush = flushOnPush;
        return this;
    }

    public PersistentExecutorOptions<T> setAutoFlushMs(long autoFlushMs) {
        this.autoFlushMs = autoFlushMs;
        return this;
    }

    public PersistentExecutorOptions<T> setDeleteOldestOnOverflow(boolean deleteOldestOnOverflow) {
        this.deleteOldestOnOverflow = deleteOldestOnOverflow;
        return this;
    }

    public PersistentExecutorOptions<T> setInitialBufferCapacity(int initialBufferCapacity) {
        this.initialBufferCapacity = initialBufferCapacity;
        return this;
    }

    public PersistentExecutorOptions<T> setMaxBufferCapacity(int maxBufferCapacity) {
        this.maxBufferCapacity = maxBufferCapacity;
        return this;
    }

    public PersistentExecutorOptions<T> setFallbackBufferCapacity(int fallbackBufferCapacity) {
        this.fallbackBufferCapacity = fallbackBufferCapacity;
        return this;
    }

    public PersistentExecutorOptions<T> setThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public PersistentExecutorOptions<T> setMaxSize(long maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public DisqBuilder<T> apply(DisqBuilder<T> builder) {
        return builder.setSerializer(this.serializer).setFlushOnPush(this.flushOnPush).setFlushOnPop(this.flushOnPop).setAutoFlushMs(this.autoFlushMs).setFallbackBufferCapacity(this.fallbackBufferCapacity).setMaxBufferCapacity(this.maxBufferCapacity).setInitialBufferCapacity(this.initialBufferCapacity).setDeleteOldestOnOverflow(this.deleteOldestOnOverflow).setMaxSize(this.maxSize).setThreadCount(this.threadCount);
    }
}

