/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.io.Serializable;
import java.util.Locale;
import net.intelie.live.ElementInfo;
import net.intelie.live.LiveUrls;
import net.intelie.live.Query;
import net.intelie.live.QueryListener;
import net.intelie.live.ValidationBuilder;

public class QueryAtom
implements Serializable {
    private final Query query;
    private final String url;

    public QueryAtom(Query query, String url) {
        if (url == null) {
            url = LiveUrls.console();
        }
        this.query = query;
        this.url = url;
    }

    public Query query() {
        return this.query;
    }

    public String url() {
        return this.url;
    }

    public QueryAtom ensureNoFollow() {
        return new QueryAtom(this.query.follow(false), this.url);
    }

    public QueryAtom fixDescription(String host) {
        return new QueryAtom(this.query.description(String.format((Locale)null, "(%s) %s", host, this.query.getDescription() != null ? this.query.getDescription() : "Started from API")), this.url);
    }

    public QueryAtom listenWith(QueryListener listener) {
        return new QueryAtom(this.query.listenWith(listener), this.url);
    }

    public ValidationBuilder validate() {
        return new ValidationBuilder().requiredNotNull(this.query, "query").push(this.query != null).requiredValue(this.query.getProvider(), "provider").requiredValue(this.query.getExpression(), "provider").pop();
    }

    public ElementInfo describe() {
        String description = this.query.getDescription();
        if (description == null) {
            description = "no description";
        }
        return new ElementInfo("query", description, this.query.getProvider() + ": " + this.query.getExpression(), this.url);
    }
}

