/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import net.intelie.live.util.SafeCloseable;

public final class SettingsOptions {
    private final Boolean log;
    private final Boolean buffer;
    private final Boolean transaction;

    public SettingsOptions() {
        this(null, null, null);
    }

    private SettingsOptions(Boolean log, Boolean buffer, Boolean transaction) {
        this.log = log;
        this.buffer = buffer;
        this.transaction = transaction;
    }

    public SettingsOptions enableLog(Boolean log) {
        return new SettingsOptions(log, this.buffer, this.transaction);
    }

    public SettingsOptions enableBuffer(Boolean buffer) {
        return new SettingsOptions(this.log, buffer, this.transaction);
    }

    public SettingsOptions enableTransaction(Boolean transaction) {
        return new SettingsOptions(this.log, this.buffer, transaction);
    }

    public Boolean log() {
        return this.log;
    }

    public Boolean buffer() {
        return this.buffer;
    }

    public Boolean transaction() {
        return this.transaction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SettingsOptions that = (SettingsOptions)o;
        return Objects.equals(this.log, that.log) && Objects.equals(this.buffer, that.buffer) && Objects.equals(this.transaction, that.transaction);
    }

    public int hashCode() {
        return Objects.hash(this.log, this.buffer, this.transaction);
    }

    public String toString() {
        return "{log=" + this.log + ", buffer=" + this.buffer + ", transaction=" + this.transaction + '}';
    }

    private static class StackState {
        private final Deque<Boolean> queue = new ArrayDeque<Boolean>();
        private final boolean defaultValue;
        private int count = 0;

        public StackState(boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        public SafeCloseable push(Boolean value) {
            boolean isTrue = this.inherit(value, this.queue.peekLast());
            this.queue.addLast(isTrue);
            if (isTrue) {
                ++this.count;
            }
            return () -> {
                if (isTrue) {
                    --this.count;
                }
                this.queue.pollLast();
            };
        }

        public boolean firstTrue() {
            return this.count == 1 && this.queue.getLast() != false;
        }

        public boolean value() {
            return this.inherit(this.queue.peekLast(), this.defaultValue);
        }

        private boolean inherit(Boolean a, Boolean b) {
            return a != null ? a : (b != null ? b : this.defaultValue);
        }
    }

    public static class Stack {
        private final ThreadLocal<StackState> queue = ThreadLocal.withInitial(() -> new StackState(defaultValue));

        public Stack(boolean defaultValue) {
        }

        public SafeCloseable push(Boolean value) {
            return this.queue.get().push(value);
        }

        public boolean value() {
            return this.queue.get().value();
        }

        public boolean firstTrue() {
            return this.queue.get().firstTrue();
        }
    }
}

