/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public interface StopReason {
    public boolean error();

    public boolean userAction();

    public String message();

    public static class Shutdown
    extends Base {
        public Shutdown() {
            super("The statement is being shut down.");
        }

        @Override
        public boolean userAction() {
            return true;
        }
    }

    public static class Partial
    extends Base {
        public Partial() {
            super("Partial query limit reached.");
        }
    }

    public static class NoRealtime
    extends Base {
        public NoRealtime() {
            super("Query does not require continuous execution. Shutting down.");
        }

        @Override
        public boolean userAction() {
            return false;
        }
    }

    public static class Error
    extends Base {
        private final transient Throwable exception;

        public Error(Throwable exception) {
            super(exception.getClass().getSimpleName() + ": " + exception.getMessage());
            this.exception = exception;
        }

        public Throwable exception() {
            return this.exception;
        }

        @Override
        public boolean error() {
            return true;
        }
    }

    public static class Custom
    extends Base {
        private final boolean error;
        private final boolean userAction;

        public Custom(boolean error, boolean userAction, String message) {
            super(message);
            this.error = error;
            this.userAction = userAction;
        }

        @Override
        public boolean error() {
            return this.error;
        }

        @Override
        public boolean userAction() {
            return this.userAction;
        }
    }

    public static class Remote
    extends Base {
        public Remote(String message) {
            super(message);
        }

        @Override
        public boolean error() {
            return true;
        }
    }

    public static class Runtime
    extends Base {
        private final String runtime;

        public Runtime(String runtime) {
            super("The selected runtime provider is unavailable: " + runtime);
            this.runtime = runtime;
        }

        public String runtime() {
            return this.runtime;
        }

        @Override
        public boolean error() {
            return true;
        }
    }

    public static class Dependency
    extends Base {
        private final Set<String> dependencies;

        public Dependency(String ... dependencies) {
            this(Arrays.asList(dependencies));
        }

        public Dependency(Collection<String> dependencies) {
            super("There are missing dependencies: " + Joiner.on((String)", ").join(dependencies));
            this.dependencies = new HashSet<String>(dependencies);
        }

        public Set<String> dependencies() {
            return this.dependencies;
        }

        @Override
        public boolean error() {
            return true;
        }
    }

    public static abstract class Base
    implements StopReason {
        private String message;

        public Base(String message) {
            this.message = message;
        }

        @Override
        public boolean userAction() {
            return false;
        }

        @Override
        public boolean error() {
            return false;
        }

        @Override
        public final String message() {
            return this.message;
        }

        public String toString() {
            return this.message();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Base)) {
                return false;
            }
            Base that = (Base)o;
            return Objects.equals(this.message, that.message) && Objects.equals(this.getClass(), that.getClass());
        }

        public int hashCode() {
            return Objects.hash(this.message, this.getClass());
        }
    }
}

