/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.util.Collection;
import java.util.LinkedList;
import net.intelie.live.ElementState;
import net.intelie.live.ElementStatus;

public class ValidationBuilder {
    public static final String MUST_DEFINE = "Must define %s";
    private final String current;
    private final ValidationBuilder next;
    private final boolean valid;
    private final boolean pushed;
    private final ValidationBuilder unpushed;

    public ValidationBuilder() {
        this.current = null;
        this.next = null;
        this.valid = true;
        this.pushed = true;
        this.unpushed = this;
    }

    private ValidationBuilder(String current, ValidationBuilder next, boolean valid, boolean pushed, ValidationBuilder unpushed) {
        this.current = current;
        this.next = next;
        this.valid = valid;
        this.pushed = pushed;
        this.unpushed = unpushed;
    }

    public ValidationBuilder requiredValue(Iterable value, String name) {
        boolean isEmpty = value == null || (value instanceof Collection ? ((Collection)value).isEmpty() : !value.iterator().hasNext());
        return this.required(!isEmpty, MUST_DEFINE, name);
    }

    public ValidationBuilder requiredValue(String value, String name) {
        boolean isNullOrEmpty = value == null || value.length() == 0;
        return this.required(!isNullOrEmpty, MUST_DEFINE, name);
    }

    public ValidationBuilder requiredNotNull(Object value, String name) {
        return this.required(value != null, MUST_DEFINE, name);
    }

    public ValidationBuilder required(boolean condition, String line, Object ... objs) {
        return this.add(true, condition, line, objs);
    }

    public ValidationBuilder optional(boolean condition, String line, Object ... objs) {
        return this.add(false, condition, line, objs);
    }

    private ValidationBuilder add(boolean required, boolean condition, String line, Object[] objs) {
        if (!this.pushed || condition) {
            return this;
        }
        return new ValidationBuilder(String.format(null, line, objs), this, !required && this.valid, this.pushed, this.unpushed);
    }

    public ValidationBuilder push(boolean condition) {
        return new ValidationBuilder(this.current, this.next, this.valid, this.pushed && condition, this);
    }

    public ValidationBuilder pop() {
        return new ValidationBuilder(this.current, this.next, this.valid, this.unpushed.pushed, this.unpushed.unpushed);
    }

    public boolean valid() {
        return this.valid;
    }

    private void addTo(Collection<String> msgs) {
        if (this.next == null) {
            return;
        }
        this.next.addTo(msgs);
        msgs.add(this.current);
    }

    public ElementState toStatus() {
        LinkedList<String> list = new LinkedList<String>();
        this.addTo(list);
        return new ElementState(this.valid ? ElementStatus.VALID : ElementStatus.INVALID, list);
    }
}

