/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.common.base.Objects;

public class Version
implements Comparable<Version> {
    private final net.intelie.pipes.Version version;

    private Version(net.intelie.pipes.Version version) {
        new VersionHolder();
        this.version = version;
    }

    public static Version fromString(String version) {
        net.intelie.pipes.Version loaded = net.intelie.pipes.Version.fromString((String)version);
        return Version.makeLiveVersion(loaded);
    }

    private static Version makeLiveVersion(net.intelie.pipes.Version loaded) {
        if (loaded == null) {
            return null;
        }
        return new Version(loaded);
    }

    public static Version load(String path) {
        net.intelie.pipes.Version loaded = net.intelie.pipes.Version.load((String)path);
        return Version.makeLiveVersion(loaded);
    }

    public static Version current() {
        return VersionHolder.instance;
    }

    public boolean accepts(Version currentVersion) {
        return this.compareTo(currentVersion) <= 0 || this.version.major() == currentVersion.major() && this.version.minor() == currentVersion.minor();
    }

    public String value() {
        return this.version.value();
    }

    public int major() {
        return this.version.major();
    }

    public int minor() {
        return this.version.minor();
    }

    public int patch() {
        return this.version.patch();
    }

    public boolean release() {
        return this.version.release();
    }

    public String simple() {
        return this.version.simple();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version that = (Version)o;
        return Objects.equal((Object)this.version, (Object)that.version);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.version});
    }

    @Override
    public int compareTo(Version o) {
        return this.version.compareTo(o.version);
    }

    public String complete() {
        return this.version.complete();
    }

    public String toString() {
        return this.complete();
    }

    private static class VersionHolder {
        public static final Version instance = new Version(net.intelie.pipes.Version.load((String)"/LIVE_VERSION"));

        private VersionHolder() {
        }
    }
}

