/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.util.Collections;
import java.util.Objects;
import net.intelie.live.ControlEvent;

public class WarningInfo
extends ControlEvent {
    private final Severity severity;
    private final String message;

    public WarningInfo(String msg) {
        this(Severity.WARNING, msg);
    }

    public WarningInfo(Severity severity, String msg) {
        super("warning", Collections.singletonMap("severityLevel", severity.ordinal()));
        this.severity = severity;
        this.message = msg;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WarningInfo)) {
            return false;
        }
        WarningInfo that = (WarningInfo)o;
        return Objects.equals(this.message, that.message) && Objects.equals((Object)this.severity, (Object)that.severity) && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.message, this.severity, super.hashCode()});
    }

    @Override
    public String toString() {
        return this.makeStringFor("message", this.message, "severity", this.severity.toString());
    }

    public static enum Severity {
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        FATAL;

    }
}

