/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.model;

import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import net.intelie.live.model.HasPerspective;
import net.intelie.live.model.HasUpdateInfo;
import net.intelie.live.model.Perspective;
import net.intelie.live.model.Unique;
import net.intelie.live.model.User;
import net.intelie.live.model.WidgetSource;
import org.hibernate.validator.constraints.Length;

@Entity
public class Datasource
implements HasPerspective,
HasUpdateInfo,
WidgetSource {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="datasource_id")
    protected Integer id;
    @Column
    @Unique
    @Length(max=255)
    private String title;
    @NotNull
    @Column(nullable=false)
    private String expression;
    @Column
    @NotNull
    @Unique
    @Pattern(regexp="[a-zA-Z][a-zA-Z_0-9_]*")
    private String identifier;
    @NotNull
    @Column
    private String provider = "pipes";
    @Column
    private String description;
    @ManyToOne
    @NotNull
    @JoinColumn(name="perspective_id")
    private Perspective perspective;
    @ManyToOne
    @JoinColumn(name="author_user_id")
    protected User author;
    @ManyToOne
    @JoinColumn(name="last_modification_author_user_id")
    protected User lastModificationAuthor;
    private boolean active = true;
    @Column(name="date_created")
    private Long dateCreated;
    @Column(name="date_modified")
    private Long dateModified;
    @Transient
    private String resetSpan;

    public Datasource() {
    }

    public Datasource(Integer id) {
        this.id = id;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.title;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setPerspective(Perspective perspective) {
        this.perspective = perspective;
    }

    public String getResetSpan() {
        return this.resetSpan;
    }

    public void setResetSpan(String resetSpan) {
        this.resetSpan = resetSpan;
    }

    @Override
    public Perspective getPerspective() {
        return this.perspective;
    }

    @Override
    public User getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(User author) {
        this.author = author;
    }

    @Override
    public User getLastModificationAuthor() {
        return this.lastModificationAuthor;
    }

    @Override
    public void setLastModificationAuthor(User author) {
        this.lastModificationAuthor = author;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public Long getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public void setDateCreated(Long dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Override
    public Long getDateModified() {
        return this.dateModified;
    }

    @Override
    public void setDateModified(Long dateModified) {
        this.dateModified = dateModified;
    }

    @Override
    public String getEventType() {
        return this.getIdentifier();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Datasource)) {
            return false;
        }
        Datasource that = (Datasource)o;
        return this.id != null && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

