/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import net.intelie.live.model.Entities;
import net.intelie.live.model.HasUpdateInfo;
import net.intelie.live.model.Perspective;
import net.intelie.live.model.SeverityLevel;
import net.intelie.live.model.Unique;
import net.intelie.live.model.User;
import net.intelie.live.model.UserGroup;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

@Entity
public class Notification
implements HasUpdateInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    @ManyToMany(targetEntity=Perspective.class)
    @JoinTable(name="notification_perspective", joinColumns={@JoinColumn(name="notification_id")}, inverseJoinColumns={@JoinColumn(name="perspective_id")})
    private final Set<Perspective> perspectives = new HashSet<Perspective>();
    @ManyToMany(targetEntity=UserGroup.class)
    @JoinTable(name="notification_group", joinColumns={@JoinColumn(name="notification_id")}, inverseJoinColumns={@JoinColumn(name="usergroup_id")})
    private final Set<UserGroup> groups = new HashSet<UserGroup>();
    @ElementCollection
    @JoinTable(name="notification_channel", joinColumns={@JoinColumn(name="notification_id")})
    @Column(name="notification_channel")
    private final Set<String> channels = new LinkedHashSet<String>();
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="notification_id")
    private Integer id;
    @NotNull(message="{default.name.blank}")
    @NotBlank(message="{default.name.blank}")
    @Unique
    private String name;
    @Column
    private boolean active;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    @Column(name="severity_level")
    private SeverityLevel severityLevel = SeverityLevel.INFO;
    @Column(name="statement_id")
    @Length(max=255)
    private String statementId = UUID.randomUUID().toString();
    @ManyToOne
    @JoinColumn(name="author_user_id")
    protected User author;
    @ManyToOne
    @JoinColumn(name="last_modification_author_user_id")
    protected User lastModificationAuthor;
    @Column(name="date_created")
    private Long dateCreated;
    @Column(name="date_modified")
    private Long dateModified;

    public Notification() {
    }

    public Notification(Integer id) {
        this.id = id;
    }

    public void addPerspectives(Perspective ... perspectives) {
        Collections.addAll(this.perspectives, perspectives);
    }

    public void addGroups(UserGroup ... groups) {
        Collections.addAll(this.groups, groups);
    }

    public void addChannels(String ... channels) {
        Collections.addAll(this.channels, channels);
    }

    public Set<User> getUsers() {
        HashSet<User> users = new HashSet<User>();
        for (UserGroup group : this.groups) {
            Set activeUsers = group.getUsers().stream().filter(User::isEnabled).collect(Collectors.toSet());
            users.addAll(activeUsers);
        }
        return users;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public SeverityLevel getSeverityLevel() {
        return this.severityLevel;
    }

    public void setSeverityLevel(SeverityLevel severityLevel) {
        this.severityLevel = severityLevel;
    }

    public Set<Perspective> getPerspectives() {
        return this.perspectives;
    }

    public Set<UserGroup> getGroups() {
        return this.groups;
    }

    public Set<String> getChannels() {
        return this.channels;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStatementId() {
        return this.statementId;
    }

    public void replacePerspectives(Set<Perspective> perspectives) {
        Entities.replaceSet(this.perspectives, perspectives);
    }

    public void replaceTeams(Set<UserGroup> teams) {
        Entities.replaceSet(this.groups, teams);
    }

    public void replaceChannels(Set<String> channels) {
        Entities.replaceSet(this.channels, channels);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public User getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(User author) {
        this.author = author;
    }

    @Override
    public User getLastModificationAuthor() {
        return this.lastModificationAuthor;
    }

    @Override
    public void setLastModificationAuthor(User author) {
        this.lastModificationAuthor = author;
    }

    @Override
    public Long getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public void setDateCreated(Long dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Override
    public Long getDateModified() {
        return this.dateModified;
    }

    @Override
    public void setDateModified(Long dateModified) {
        this.dateModified = dateModified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Notification)) {
            return false;
        }
        Notification that = (Notification)o;
        return this.id != null && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

