/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.model;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import net.intelie.live.model.CanBeBuiltin;
import net.intelie.live.model.Dashboard;
import net.intelie.live.model.HasUpdateInfo;
import net.intelie.live.model.PerspectiveTag;
import net.intelie.live.model.Rule;
import net.intelie.live.model.Unique;
import net.intelie.live.model.User;
import net.intelie.live.model.UserGroup;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

@Entity
public class Perspective
implements HasUpdateInfo,
Serializable,
CanBeBuiltin {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="perspective_id")
    private Integer id;
    @NotNull(message="{perspective.name.blank}")
    @NotBlank(message="{perspective.name.blank}")
    @Length(max=255)
    @Column(unique=true)
    @Unique
    private String name;
    @Length(max=255)
    @Column
    private String description;
    @Column
    private Boolean builtin = Boolean.FALSE;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="perspective_id", nullable=false)
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=10)
    private Set<PerspectiveTag> tags = new LinkedHashSet<PerspectiveTag>();
    @ManyToOne
    @JoinColumn(name="author_user_id")
    protected User author;
    @ManyToOne
    @JoinColumn(name="last_modification_author_user_id")
    protected User lastModificationAuthor;
    @Column(name="date_created")
    private Long dateCreated;
    @Column(name="date_modified")
    private Long dateModified;
    @OneToMany(mappedBy="perspective")
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=10)
    private final Set<Dashboard> dashboards = new HashSet<Dashboard>();
    @OneToMany(mappedBy="perspective")
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=10)
    private final Set<Rule> rules = new HashSet<Rule>();
    @ManyToMany
    @JoinTable(name="usergroup_perspective", joinColumns={@JoinColumn(name="perspective_id")}, inverseJoinColumns={@JoinColumn(name="usergroup_id")})
    private final Set<UserGroup> groups = new HashSet<UserGroup>();

    public Perspective() {
    }

    public Perspective(Integer id) {
        this();
        this.id = id;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Boolean getBuiltin() {
        return this.builtin;
    }

    public void setBuiltin(Boolean builtin) {
        this.builtin = builtin;
    }

    public Set<PerspectiveTag> getTags() {
        return this.tags;
    }

    public void clearTags() {
        this.tags.clear();
    }

    public void replaceTags(Set<PerspectiveTag> rules) {
        ArrayList toRemove = Lists.newArrayList((Iterable)Sets.difference(this.tags, rules));
        ArrayList toAdd = Lists.newArrayList((Iterable)Sets.difference(rules, this.tags));
        this.tags.removeAll(toRemove);
        this.tags.addAll(toAdd);
    }

    public void addTag(PerspectiveTag tag) {
        this.tags.add(tag);
    }

    public void removeTag(PerspectiveTag tag) {
        this.tags.remove(tag);
    }

    public boolean containsTag(PerspectiveTag tag) {
        return this.tags.contains(tag);
    }

    @Override
    public User getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(User author) {
        this.author = author;
    }

    @Override
    public User getLastModificationAuthor() {
        return this.lastModificationAuthor;
    }

    @Override
    public void setLastModificationAuthor(User author) {
        this.lastModificationAuthor = author;
    }

    @Override
    public Long getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public void setDateCreated(Long dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Override
    public Long getDateModified() {
        return this.dateModified;
    }

    @Override
    public void setDateModified(Long dateModified) {
        this.dateModified = dateModified;
    }

    public Set<Dashboard> getDashboards() {
        return this.dashboards;
    }

    public Set<Rule> getRules() {
        return this.rules;
    }

    public Set<UserGroup> getGroups() {
        return this.groups;
    }

    public void addGroup(UserGroup group) {
        this.groups.add(group);
    }

    public void removeGroup(UserGroup group) {
        this.groups.remove(group);
    }

    public void clearGroups() {
        this.groups.clear();
    }

    public void replaceGroups(Set<UserGroup> groups) {
        ArrayList toRemove = Lists.newArrayList((Iterable)Sets.difference(this.groups, groups));
        ArrayList toAdd = Lists.newArrayList((Iterable)Sets.difference(groups, this.groups));
        this.groups.removeAll(toRemove);
        this.groups.addAll(toAdd);
    }

    public void addDashboard(Dashboard dashboard) {
        this.dashboards.add(dashboard);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Perspective)) {
            return false;
        }
        Perspective that = (Perspective)o;
        return this.id != null && Objects.equal((Object)this.id, (Object)that.id);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }
}

