/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.model;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Set;

public enum PrimitiveType implements Serializable
{
    INT(Integer.class),
    FLOAT(Float.class),
    STRING(String.class),
    BOOL(Boolean.class),
    LONG(Long.class),
    BYTE(Byte.class),
    SHORT(Short.class),
    DOUBLE(Double.class),
    BIG_DECIMAL(BigDecimal.class);

    public static final Set<Class<?>> PRIMITIVE_TYPES;
    private final Class<?> clazz;

    private PrimitiveType(Class<?> clazz) {
        this.clazz = clazz;
    }

    public static PrimitiveType fromValue(Object value) {
        for (PrimitiveType type : PrimitiveType.values()) {
            if (!type.isInstance(value)) continue;
            return type;
        }
        return STRING;
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return PRIMITIVE_TYPES.contains(clazz);
    }

    public static PrimitiveType fromClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        for (PrimitiveType type : PrimitiveType.values()) {
            if (type.clazz != clazz) continue;
            return type;
        }
        throw new IllegalArgumentException("cannot map java class " + clazz + " to a primitive type.");
    }

    public static Class<?> toClass(PrimitiveType type) {
        if (type == null) {
            return Object.class;
        }
        return type.toClass();
    }

    private boolean isInstance(Object obj) {
        return this.clazz.isInstance(obj);
    }

    public Class<?> toClass() {
        return this.clazz;
    }

    static {
        PRIMITIVE_TYPES = Sets.newHashSet((Object[])new Class[]{Float.class, Integer.class, String.class, Boolean.class, Double.class, Long.class, Short.class, Byte.class, BigDecimal.class});
    }
}

