/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.model;

import java.util.Objects;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import net.intelie.live.model.HasPerspective;
import net.intelie.live.model.HasUpdateInfo;
import net.intelie.live.model.Perspective;
import net.intelie.live.model.RuleEventCount;
import net.intelie.live.model.RuleEventTimestamp;
import net.intelie.live.model.SeverityLevel;
import net.intelie.live.model.Unique;
import net.intelie.live.model.User;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
public class Rule
implements HasPerspective,
HasUpdateInfo {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="rule_id")
    private Integer id;
    @NotNull
    @Length(max=255)
    @Column(unique=true)
    @Unique
    @NotBlank
    private String name;
    private String description;
    @Column
    private String text;
    @NotNull
    private SeverityLevel severity;
    @ManyToOne
    @NotNull
    @JoinColumn(name="perspective_id")
    private Perspective perspective;
    @Column
    @NotNull
    private String expression;
    @NotNull
    @Column
    private String provider = "esper";
    private boolean active = true;
    @Column(name="statement_id")
    @Length(max=255)
    private String statementId = UUID.randomUUID().toString();
    @ManyToOne
    @JoinColumn(name="author_user_id")
    protected User author;
    @ManyToOne
    @JoinColumn(name="last_modification_author_user_id")
    protected User lastModificationAuthor;
    @Column(name="date_created")
    private Long dateCreated;
    @Column(name="date_modified")
    private Long dateModified;
    @OneToOne(mappedBy="rule")
    private RuleEventCount eventCount;
    @OneToOne(mappedBy="rule")
    private RuleEventTimestamp lastEventTimestamp;

    public Rule() {
    }

    public Rule(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setPerspective(Perspective perspective) {
        this.perspective = perspective;
    }

    @Override
    public Perspective getPerspective() {
        return this.perspective;
    }

    public void setSeverity(SeverityLevel severity) {
        this.severity = severity;
    }

    public SeverityLevel getSeverity() {
        return this.severity;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getStatementId() {
        return this.statementId;
    }

    public void setStatementId(String statementId) {
        this.statementId = statementId;
    }

    @Override
    public User getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(User author) {
        this.author = author;
    }

    @Override
    public User getLastModificationAuthor() {
        return this.lastModificationAuthor;
    }

    @Override
    public void setLastModificationAuthor(User author) {
        this.lastModificationAuthor = author;
    }

    @Override
    public Long getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public void setDateCreated(Long dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Override
    public Long getDateModified() {
        return this.dateModified;
    }

    @Override
    public void setDateModified(Long dateModified) {
        this.dateModified = dateModified;
    }

    public RuleEventCount getEventCount() {
        return this.eventCount;
    }

    public RuleEventTimestamp getLastEventTimestamp() {
        return this.lastEventTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rule)) {
            return false;
        }
        Rule that = (Rule)o;
        return this.id != null && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

