/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.model;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import net.intelie.live.model.HasUpdateInfo;
import net.intelie.live.model.StreamProperty;
import net.intelie.live.model.StreamPropertyQualifier;
import net.intelie.live.model.Unique;
import net.intelie.live.model.User;
import net.intelie.live.model.WidgetSource;
import org.hibernate.validator.constraints.Length;

@Entity
@Table
@Inheritance(strategy=InheritanceType.JOINED)
public class Stream
implements Serializable,
HasUpdateInfo,
WidgetSource {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="stream_id")
    private Integer id;
    @NotNull
    @Length(max=255)
    @Unique
    @Pattern(regexp="^[a-zA-Z_]+[a-zA-Z0-9_]*$")
    private String name;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="stream_id", nullable=false)
    private final Set<StreamProperty> properties = new LinkedHashSet<StreamProperty>();
    @ManyToOne
    @JoinColumn(name="author_user_id")
    protected User author;
    @ManyToOne
    @JoinColumn(name="last_modification_author_user_id")
    protected User lastModificationAuthor;
    @Column(name="date_created")
    private Long dateCreated;
    @Column(name="date_modified")
    private Long dateModified;

    public Stream() {
    }

    public Stream(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Stream(Integer id) {
        this.id = id;
    }

    public Stream(String name) {
        this.name = name;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.id != null && this.name != null && !this.name.equals(name)) {
            throw new RuntimeException("cannot alter name of existing stream");
        }
        this.name = name;
    }

    public Set<StreamProperty> getProperties() {
        return this.properties;
    }

    public Set<StreamProperty> getIdentifierProperties() {
        HashSet<StreamProperty> identifierProperties = new HashSet<StreamProperty>();
        for (StreamProperty property : this.properties) {
            if (!property.getPropertyQualifier().equals(StreamPropertyQualifier.IDENTIFIER)) continue;
            identifierProperties.add(property);
        }
        return identifierProperties;
    }

    public void addProperty(StreamProperty streamProperty) {
        StreamProperty current = this.getPropertyByName(streamProperty.getName());
        if (current != null && !current.getType().equals(streamProperty.getType())) {
            throw new IllegalArgumentException(String.format((Locale)null, "A propriedade %s j\u00e1 existe neste fluxo com tipo diferente.", streamProperty.getName()));
        }
        streamProperty.setStream(this);
        this.properties.add(streamProperty);
    }

    public void replaceProperties(Set<StreamProperty> properties) {
        ArrayList toRemove = new ArrayList(Sets.difference(this.properties, properties));
        ArrayList toAdd = new ArrayList(Sets.difference(properties, this.properties));
        this.properties.removeAll(toRemove);
        for (StreamProperty property : toAdd) {
            this.addProperty(property);
        }
    }

    public StreamProperty getPropertyByName(String name) {
        if (name == null) {
            return null;
        }
        for (StreamProperty property : this.properties) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    @Override
    public User getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(User author) {
        this.author = author;
    }

    @Override
    public User getLastModificationAuthor() {
        return this.lastModificationAuthor;
    }

    @Override
    public void setLastModificationAuthor(User author) {
        this.lastModificationAuthor = author;
    }

    @Override
    public Long getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public void setDateCreated(Long dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Override
    public Long getDateModified() {
        return this.dateModified;
    }

    @Override
    public void setDateModified(Long dateModified) {
        this.dateModified = dateModified;
    }

    public static List<Stream> sort(Set<Stream> streams) {
        ArrayList<Stream> sortedStreams = new ArrayList<Stream>(streams);
        sortedStreams.sort(Comparator.comparing(Stream::getName));
        return sortedStreams;
    }

    @Override
    public String getEventType() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Stream)) {
            return false;
        }
        Stream that = (Stream)o;
        return this.id != null && Objects.equals(this.id, that.id);
    }

    public String toString() {
        return "Stream{properties=" + this.properties + ", name='" + this.name + '\'' + '}';
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

