/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import net.intelie.live.model.PrimitiveType;
import net.intelie.live.model.Stream;
import net.intelie.live.model.StreamPropertyQualifier;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"name"})}, name="stream_property")
public class StreamProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="stream_property_id")
    private Integer id;
    @NotNull
    @Pattern(regexp="^[a-zA-Z_]+[a-zA-Z0-9_]*$")
    private String name;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private PrimitiveType type;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="property_qualifier")
    private StreamPropertyQualifier propertyQualifier;
    @NotNull
    @ManyToOne
    @JoinColumn(name="stream_id", nullable=false, updatable=false, insertable=false)
    private Stream stream;

    public StreamProperty() {
    }

    public StreamProperty(String name, PrimitiveType type) {
        this(name, type, StreamPropertyQualifier.VALUE);
    }

    public StreamProperty(String name, PrimitiveType type, StreamPropertyQualifier qualifier) {
        this.name = name;
        this.type = type;
        this.propertyQualifier = qualifier;
    }

    public StreamProperty(int id) {
        this.id = id;
    }

    public StreamProperty(String name) {
        this.name = name;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PrimitiveType getType() {
        return this.type;
    }

    public void setType(PrimitiveType type) {
        this.type = type;
    }

    public Stream getStream() {
        return this.stream;
    }

    public void setStream(Stream stream) {
        this.stream = stream;
    }

    public StreamPropertyQualifier getPropertyQualifier() {
        return this.propertyQualifier;
    }

    public void setPropertyQualifier(StreamPropertyQualifier propertyQualifier) {
        this.propertyQualifier = propertyQualifier;
    }

    public static List<StreamProperty> sort(Set<StreamProperty> properties) {
        ArrayList<StreamProperty> streamProperties = new ArrayList<StreamProperty>(properties);
        streamProperties.sort(Comparator.comparing(StreamProperty::getName));
        return streamProperties;
    }

    public String toString() {
        return "StreamProperty{name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamProperty)) {
            return false;
        }
        StreamProperty that = (StreamProperty)o;
        return this.id != null && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

